#!/usr/bin/python

import gtk
import egg.trayicon
import os 
import stat
icon = egg.trayicon.TrayIcon("ccontrol")
eventbox = gtk.EventBox()
icon.add(eventbox)

img = gtk.Image()
img.set_from_file("/home/rusty/bin/ccontrol-key.png")

DEFAULT_NAME = "default"
default_file = os.path.join(os.getenv("HOME"), ".ccontrol", DEFAULT_NAME)

def file_ok(file):
	if file[-1] == '~':
		return False
	if file[0] == '.':
		return False
	return stat.S_ISREG(os.lstat(os.path.join(os.getenv("HOME"), ".ccontrol", file)).st_mode)

def config_files():
	return filter(file_ok, os.listdir(os.path.join(os.getenv("HOME"), ".ccontrol")))

def get_current():
	return os.readlink(default_file)

def menuitem_response(file):
	if os.access(default_file, os.F_OK):
		os.unlink(default_file)
	os.symlink(file, default_file)

def icon_clicked(widget, event):
	menu = gtk.Menu()
	current = get_current()
	
	for f in config_files():
		item = gtk.CheckMenuItem(f)
		item.set_draw_as_radio(1)
		if f == current:
			item.set_active(1)
		menu.append(item)	
		item.connect_object("activate", menuitem_response, f)		
		item.show()
	
	menu.show()
	menu.popup(None, None, None, event.button, event.time)

eventbox.add(img)
eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
eventbox.connect("button_press_event", icon_clicked)
icon.show_all()

gtk.main()
