/* Ccontrol goodness. */
#ifndef _CCONTROL_H
#define _CCONTROL_H
#include <stdbool.h>

struct string
{
	char *start, *end, *pos;
};

enum type
{
	TYPE_CC,
	TYPE_CPLUSPLUS,
	TYPE_LD,
	TYPE_MAKE,
	LAST_TYPE = TYPE_MAKE,
};

struct section
{
	struct string name;

	/* Run verbose (debugging) */
	bool verbose;

	/* How many in parallel? */
	unsigned int cpus;

	/* What (if any) targets do we suppress parallel make? */
	char *no_parallel;

	/* Name of CC, C++, LD and MAKE replacements. */
	char *names[LAST_TYPE + 1];

	/* Path of ccache, distcc */
	char *ccache, *distcc;

	/* Distcc hosts. */
	char *distcc_hosts;

};

/* ccontrol.c */
#define verbose(sec, fmt, ...) \
	do { if ((sec).verbose) __verbose((fmt), ## __VA_ARGS__); } while(0) 
void __verbose(const char *fmt, ...);

/* ccontrol-parse.c */
struct section read_config(const char *configname);

/* ccontrol-lock.c */
void grab_lock(const char *configname, struct section sec, bool slow,
	       enum type type);

/* ccontrol-identify.c */
enum type what_am_i(char *argv[], bool distcc, bool *slow);
#endif /* _CCONTROL_H */
