/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#ifndef __GESTURE_HISTORY_DISPLAY_H
#define __GESTURE_HISTORY_DISPLAY_H

#include "Spells.H"
#include "PlayerGestures.H"

#include <qhbox.h>
#include <qvbox.h>
#include <map>
#include <qlabel.h>

class GestureHistoryDisplay : public QHBox {
public:
    GestureHistoryDisplay(QWidget *Parent);
    void AddPlayer(const QString &Name, int Id);
    void AddGestures(int PlayerId, Gesture Left, Gesture Right);
    void Clear();

private:
    struct PlayerToDisplay {
	QString name;
	PlayerGestures *gestureDisplay;
	QLabel *label;
	QVBox *vb;
    };
    map<int, PlayerToDisplay> players;
};


#endif
