#ifndef _RING_BUFFER_H
#define _RING_BUFFER_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

using namespace std;

#define RING_BUFFER_SIZE 8192

class RingBuffer {
public:
    RingBuffer(void);

    // Copy length bytes from BufferStart and increment it by length
    char * RingBuffer::ReadFromStart(char *dest, int length);
    // Copy length bytes from BufferStart to dest
    char * RingBuffer::Peek(char *dest, int length, int offset) const;
    // Copy length bytes to BufferEnd and increment it by length
    void RingBuffer::AppendToEnd(const char *src, int length);

    // Returns true if the buffer contains data
    int RingBuffer::ContainsData(void) const;
    // Returns the number of bytes used in the buffer
    int RingBuffer::BufferUsed(void) const;
    // Returns the number of bytes free from BufferEnd to
    // the end of the buffer
    int RingBuffer::BytesFreeToEnd(void) const;
    // Returns the number of bytes used to the end of the
    // buffer from BufferStart
    int RingBuffer::BytesUsedToEnd(void) const;

    // Returns a pointer to the end of the buffer
    char * RingBuffer::BufferEnd(void);
    // Increments BufferEnd by length and returns the new BufferEnd,
    // Useful if you have used BufferEnd as an argument to read()
    const char * RingBuffer::BufferEnd(int length);
    // Returns a pointer to the start of the buffer
    const char * RingBuffer::BufferStart(void) const;
    // Increments BufferStart by length and returns the new BufferStart,
    // Useful if you have used BufferStart as an argument to write()
    const char * RingBuffer::BufferStart(int length);

private:
    int ringBufferStart, ringBufferEnd;
    char ringBuffer[RING_BUFFER_SIZE];
};

#endif

