/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "NonWizard.H"
#include <assert.h>

NonWizard::NonWizard(int MonsterType, int DamageInflicted, int NumHitPoints,
		     Wizard *Owner)
    : BaseCreature(DamageInflicted, NumHitPoints), monsterType(MonsterType), 
      owner(Owner)
{
}

bool
NonWizard::applyRemoveEnchantmentSpell(string *Message)
{
    *Message = "%S casts Remove Enchantment on %T destroying it";
    changeNumHitPoints(-1000);
    return true;
}

bool
NonWizard::applyDispelMagicSpell(string *Message)
{
    *Message = "%S casts Dispel Magic on %T dispelling it";
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyCharmPersonSpell(string *Message, BaseCreature *)
{
    *Message = "%S casts Charm Person on %T with no effect";
    return false;
}

bool
NonWizard::applyCharmMonsterSpell(string *Message, BaseCreature *Source)
{
    // Need to handle owner transfer?
    *Message = "%S casts Charm Monster on %T and now controls %T";
    owner->removeMonster(this);
    owner = dynamic_cast<Wizard *>(Source);
    owner->addMonster(this);
    assert(owner!=NULL);
    return true;
}

bool
NonWizard::applyFearSpell(string *Message)
{
    *Message = "%S casts Fear on %T with no effect";
    return false;
}

bool
NonWizard::applyAntiSpell(string *Message)
{
    *Message = "%S casts Anti Spell on %T with no effect";
    return false;
}

bool
NonWizard::applyBlindnessSpell(string *Message)
{
    *Message = "%S casts blindness on %T destroying it";
    /* Dead and cannot attack that turn */
    /* Need to handle removal of attack this turn */
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyInvisibilitySpell(string *Message)
{
    *Message = "%S casts Invisibility on %T destroying it";
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyDelayedEffectSpell(string *Message)
{
    *Message = "%S casts Delayed Effect on %T with no effect";
    return false;
}

bool
NonWizard::applyPermanencySpell(string *Message)
{
    *Message = "%S casts Permanency on %T with no effect";
    return false;
}

int
NonWizard::getMonsterType() const
{
    return monsterType;
}

Wizard *
NonWizard::getOwner() const
{
    return owner;
}
