/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#ifndef __MAINSCREEN_H
#define __MAINSCREEN_H

#include <string>
#include <vector>

using namespace std;

#include <qmainwindow.h>
#include <qtextedit.h>
#include <qsocketnotifier.h>

#include "PlayerStatus.H"
#include "PlayerInput.H"
#include "SCClient.H"
#include "GestureHistoryDisplay.H"

class MainScreen : public QMainWindow
{
    Q_OBJECT

signals:

 void Quit();

public slots:

  void SCReadyToRead(int FD);
  void SCReadyToWrite(int FD);
  void PlayerMadeSelection(int Selection);
  void showConnectDialog();
  void quitSelection();

public:
    MainScreen(QWidget *Parent=0, const char *Name=0);

    PlayerStatus *playerStatus;
    PlayerInput *playerInput;

private:

    enum UserState {
	WAITING,
	ASK_LEFT_GESTURE,
	ASK_RIGHT_GESTURE,
	ASK_RIGHT_SPELL,
	ASK_LEFT_SPELL,
	ASK_LEFT_SPELL_DIRECTION,
	ASK_RIGHT_SPELL_DIRECTION,
	ASK_MONSTER_DIRECTION,
	ASK_CHOOSE_CHARM_HAND,
	ASK_CHOOSE_PARALYSIS_HAND,
	ASK_CHOOSE_CHARM_GESTURE
    };

    void LogToUserMsg(const string &Message);
    void LogToUser(const QString &Message);

    void ConnectToHost(const QString &HostName, const QString &Username,
		       bool isObserver);

    void AskUserForGestures();
    void AskUserForSpellChoices();
    void AskUserForRightSpellChoices();
    void AskUserForSpellDirections();
    void AskUserForSpellDirectionsRight();
    void AskUserForMonsterDirections();
    void AskUserForNextMonsterDirection();
    void SetQueryForMonsterDirection();
    void AskForCharmPersonCtrlHand();
    void SetQueryForCharmPersonCtrlHand();
    void AskForParalysisCtrlHand();
    void SetQueryForParalysisCtrlHand();
    void AskForCharmPersonCtrlGesture();
    void SetQueryForCharmPersonCtrlGesture();

    void ShowSpellsCast();
    void ShowEventInfo();
    void ShowWizardGestures();
    void ShowMonsterAttackInfo();
    void HandleEndGame();

    void ConvertSpellList(const vector<Spell> &SpellList,
			  map<QString, int> *SpellNames);
    void InitialiseHistoryDisplay();
    void setPlayerInputWait();

    void HandleMessages();


    SCClient *SC;
    QTextEdit *outputLog;
    QSocketNotifier *SCReadNotifier;
    QSocketNotifier *SCWriteNotifier;
    UserState currentRequestState;
    vector<QString> gestureStringList;
    int leftGesture;
    vector<Spell> possibleLeftSpells, possibleRightSpells;
    Spell leftSpell, rightSpell;
    map<QString, int> targetNames;
    int leftTarget, rightTarget;
    vector<int> monstersToDirect;
    map<int, int> monsterDirections;
    vector<int>::iterator monsterToDirect;
    GestureHistoryDisplay *ghd;
    bool initialisedHistoryDisplay;

    vector<int> outstandingHandRequests;
    vector<QString> handNames;
    int currentTarget;
    bool amObserver;
};

#endif
