#ifndef _GESTUREHISTORY_H
#define _GESTUREHISTORY_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <vector>
#include <deque>

#include "Spells.H"

using namespace std;

class GestureHistory
{
public:
    void addLeftGesture(enum Gesture NewGesture);
    void addRightGesture(enum Gesture NewGesture);

    // Get current gestures
    void getCurrentGestures(Gesture *Left, Gesture *Right) const;

    /* To explicitly set the last gesture - eg for
       charm person */
    void setLeftGesture(enum Gesture NewGesture);
    void setRightGesture(enum Gesture NewGesture);

    /* Gets the spells cast with the last gestures added */
    void getSpells(vector<Spell> *LeftHandSpellList, 
		   vector<Spell> *RightHandSpellList) const;
    /* Returns the number of spells */

    const deque<Gesture> &getLeftGestures() const;
    const deque<Gesture> &getRightGestures() const;

    // Clear all gestures
    void clear();

private:
    deque<Gesture> leftHandGestures;
    deque<Gesture> rightHandGestures;

    
};

#endif
