#ifndef _GAME_H
#define _GAME_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <vector>
#include "Player.H"

class NonWizard;

using namespace std;

class Game {
public:
    Game(int ServerFD);
    // ServerFD is FD to accept new player connections on

    enum GameState {
	PLAYERS_JOINING,
	PLAYING,
	GAME_ENDED
    };

    enum GameState getGameState() const;

    int numPlayers() const;
    int numPlayersAlive();

    int PlayersJoining(time_t ReferenceTime);
    // Returns number of players joined for game

    void StartGame();

    // Reset game state in preparation for a new game
    void Reset();

private:
    void sendSpellsToAll(const Player::SpellCast &SpellInfo);

    void addPlayer(int FD, Player *NewPlayer);

    void ApplySpells();
    void GetMonsterDirections();

    void WaitForResponses(int Timeout, bool RemoveClient = false);

    static NonWizard *createMonster(Spell SummonSpell, Wizard *Owner);

    void monsterAttack(NonWizard *Source, BaseCreature *Target);

    void PlayerDisconnected(const RemoteConnection::ConnectionError &Error,
			    bool RemovePlayer);

    enum GameState gameState;
    map<int, Player *> players; // FD to player object mapping
    vector<BaseCreature *> creatures; // Includes players 

    struct EventMessage {
	EventMessage(int EventType, int MessageSource, int Source,
		     int Target, int Misc, string Message) :
	    eventType(EventType), messageSource(MessageSource),
	    source(Source), target(Target), misc(Misc), message(Message)
	{};

	int eventType;
	int messageSource;
	int source;
	int target;
	int misc;
	string message;
    }; 

    void SendEventMessageToAll(int EventType, int MessageSource,
			       int Source, int Target, int Misc,
			       const string &Message);
    void SendEventMessageToAll(const EventMessage &Message);
    void SendEventMessageToAllCache(int EventType, int MessageSource,
				    int Source, int Target, int Misc,
				    const string &Message);
    void SendEventMessageToAllCacheFlush();


    vector<EventMessage> eventMessageCache;
    vector<string> playerNameList;

    int serverFD;
    int turnTimeout;
};

#endif
