/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "GestureHistoryDisplay.H"

#include <assert.h>
#include <qlabel.h>

GestureHistoryDisplay::GestureHistoryDisplay(QWidget *Parent)
    : QHBoxLayout(Parent), theParent(Parent)
{
}

void
GestureHistoryDisplay::AddPlayer(const QString &Name, int Id)
{
    PlayerToDisplay ptd;
    ptd.name = Name;
    ptd.gestureDisplay = new PlayerGestures(theParent);
    players[Id] = ptd;

    QVBoxLayout *vb = new QVBoxLayout(theParent);
    QLabel *label = new QLabel(Name, theParent);
    vb->addWidget(label, 0, Qt::AlignHCenter);
    label->show();
    vb->addLayout(ptd.gestureDisplay);
    ptd.gestureDisplay->Show();
    addLayout(vb);
    vb->activate();
}

void
GestureHistoryDisplay::AddGestures(int PlayerId, Gesture Left, Gesture Right)
{
    assert(players.find(PlayerId)!=players.end());

    players[PlayerId].gestureDisplay->AddGestures(Left, Right);
}

