#ifndef _REMOTE_CONNECTION_H
#define _REMOTE_CONNECTION_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <queue>
using namespace std;

#include "Message.H"

#define REMOTE_RING_BUFFER_SIZE 8192

class RemoteConnection {
public:

    RemoteConnection(int ConnectionFD);

    int getFD() const;

    bool pendingDataToWrite() const;

    bool haveMessageToRead() const;

    Message *getNextMessage();
    // free this memory when you're done with it.
    // don't call it unless you know you have a message ready

    void writeMessage(Message *MsgToSend);
    
    // Read data from connection
    void readData();

    // Write pending data
    void writeData();

private:
    int connectionFD;
    int ringBufferReadStart, ringBufferReadEnd;
    int ringBufferWriteStart, ringBufferWriteEnd;
    char ringBufferRead[REMOTE_RING_BUFFER_SIZE];
    char ringBufferWrite[REMOTE_RING_BUFFER_SIZE];
    int msgStart;

    struct MsgMarker {
	int start;
	int length;
    };
    queue<MsgMarker> msgsToRead;
};


#endif
