/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include "Wizard.H"

#define WIZARD_MAX_NUM_HIT_POINTS 14

Wizard::Wizard()
    : BaseCreature(1, WIZARD_MAX_NUM_HIT_POINTS)
{
}

void
Wizard::addGestures(Gesture LeftHand, Gesture RightHand)
{
    /* Need to add check for spells like confusion, amnesia, paralysis */
    gestures.addLeftGesture(LeftHand);
    gestures.addRightGesture(RightHand);
}

void
Wizard::setLeftGesture(Gesture NewGesture)
{
    gestures.setLeftGesture(NewGesture);
}

void
Wizard::setRightGesture(Gesture NewGesture)
{
    gestures.setRightGesture(NewGesture);
}

const GestureHistory &
Wizard::getGestureHistory() const
{
    return gestures;
}

bool
Wizard::applyRemoveEnchantmentSpell(string *Message)
{
    clearStateBits(ENCHANTMENT_SPELLS);
    return true;
}

bool 
Wizard::applyDispelMagicSpell(string *Message)
{
    /* This spell has other effects which are handle elsewhere,
       but it also doubles as a shield spell, the state of which
       we set here */
    return applyShieldSpell(Message);
}

bool
Wizard::applyAmnesiaSpell(string *Message)
{
    setStateBits(CS_AMNESIA);
    return true;
}

bool 
Wizard::applyConfusionSpell(string *Message)
{
    setStateBits(CS_CONFUSION);
    return true;
}

bool
Wizard::applyCharmPersonSpell(string *Message)
{
    setStateBits(CS_CHARM_PERSON);
    return true;
}

bool
Wizard::applyCharmMonsterSpell(string *Message)
{
    return false;
}

bool
Wizard::applyParalysisSpell(string *Message)
{
    setStateBits(CS_PARALYSIS);
    return true;
}

bool
Wizard::applyFearSpell(string *Message)
{
    setStateBits(CS_FEAR);
    return true;
}

bool
Wizard::applyAntiSpell(string *Message)
{
    gestures.addLeftGesture(GST_ANTISPELL);
    gestures.addRightGesture(GST_ANTISPELL);
    return true;
}

bool
Wizard::applyBlindnessSpell(string *Message)
{
    counterBlindness = 3;
    setStateBits(CS_BLINDED);
    return true;
}

bool
Wizard::applyInvisibilitySpell(string *Message)
{
    counterInvisibility = 3;
    setStateBits(CS_INVISIBILITY);
    return true;
}

bool 
Wizard::applyDelayedEffectSpell(string *Message)
{
    setStateBits(CS_DELAYED_EFFECT);
    return true;
}

bool
Wizard::applyPermanencySpell(string *Message)
{
    setStateBits(CS_PERMANENCY);
    return true;
}

