#ifndef _PLAYER_H
#define _PLAYER_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "Wizard.H"
#include "RemoteConnection.H"

class Player : public Wizard {
public:

    struct SpellCast {
	Player *source;
	BaseCreature *target;
	Spell spellCast;
	bool spellWorked;
	string resultMessage;
    };

    Player(int FD);

    void sendNewPlayerInfo(Player *NewPlayer);

    void askForGestures();

    void sendGesturesSeen(Player *OfPlayer);
    void sendGesturesSeenEnd();
    
    void askForSpellSelection(const vector<Spell> &LeftHandSpells,
			      const vector<Spell> &RightHandSpells);

    void getSpellsSelected(Spell *LeftHandSpell, Spell *RightHandSpell);
    // might not need this one?

    // Ask player who to direct spells at
    void askForSpellDirections(const vector<int> &ValidTargetIDs);

    void getSpellsCast(Spell *LeftHandSpell, int *LeftTargetID,
		       Spell *RightHandSpell, int *RightTargetID);

    // Tell players what spells have been cast
    void sendSpellCast(const SpellCast &SpellInfo);
    void sendSpellCastEnd(); // Sent all information about spells cast

    // Tell players of the state of all other creatures
    void sendCreatureState(BaseCreature *Creature);
    void sendCreatureStateEnd();

    // Tell players that game has ended
    void sendEndGame(Player *Winner);

    // So we can work out when game can proceed
    bool amWaitingForResponse() const;
    void clearWaitForResponse();

    const RemoteConnection &connection() const;
    RemoteConnection &connection();

    // Process incoming message
    void ProcessMessage();

private:
    RemoteConnection remoteConnection;
    bool waitingForResponse;
    Spell leftHandSpell, rightHandSpell;
    int leftHandSpellTargetID, rightHandSpellTargetID;
    vector<Spell> validLHSpells;
    vector<Spell> validRHSpells;
    vector<int> validTargetIDs;

};


#endif

