/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "NonWizard.H"

NonWizard::NonWizard(const string &Name, int DamageInflicted, int NumHitPoints,
		     Wizard *Owner)
    : BaseCreature(DamageInflicted, NumHitPoints), creatureName(Name), 
      owner(Owner)
{
}

bool
NonWizard::applyRemoveEnchantmentSpell(string *Message)
{
    changeNumHitPoints(-1000);
    return true;
}

bool
NonWizard::applyDispelMagicSpell(string *Message)
{
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyAmnesiaSpell(string *Message)
{
    setStateBits(CS_AMNESIA);
    return true;
}

bool
NonWizard::applyConfusionSpell(string *Message)
{
    setStateBits(CS_CONFUSION);
    return true;
}

bool
NonWizard::applyCharmPersonSpell(string *Message)
{
    return false;
}

bool
NonWizard::applyCharmMonsterSpell(Wizard *Source, string *Message)
{
    owner = Source;
    return true;
}

bool
NonWizard::applyParalysisSpell(string *Message)
{
    setStateBits(CS_PARALYSIS);
    return true;
}

bool
NonWizard::applyFearSpell(string *Message)
{
    return true;
}

bool
NonWizard::applyAntiSpell(string *Message)
{
    return true;
}

bool
NonWizard::applyBlindnessSpell(string *Message)
{
    /* Dead and cannot attack that turn */
    /* Need to handle removal of attack this turn */
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyInvisibilitySpell(string *Message)
{
    setStateBits(CS_DEAD);
    return true;
}

bool
NonWizard::applyDelayedEffectSpell(string *Message)
{
    return false;
}

bool
NonWizard::applyPermanencySpell(string *Message)
{
    return false;
}
