/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "GestureHistory.H"

#define MAX_HISTORY_SIZE 9

void
GestureHistory::addLeftGesture(enum Gesture NewGesture)
{
    leftHandGestures.push_front(NewGesture);

    /* Drop gesture history when it gets longer than longest spell */
    if (leftHandGestures.size() > MAX_HISTORY_SIZE)
	leftHandGestures.pop_back();
}

void 
GestureHistory::addRightGesture(enum Gesture NewGesture)
{
    rightHandGestures.push_front(NewGesture);

    /* Drop gesture history when it gets longer than longest spell */
    if (rightHandGestures.size() > MAX_HISTORY_SIZE)
	rightHandGestures.pop_back();
}

void
GestureHistory::getCurrentGestures(Gesture *Left, Gesture *Right) const
{
    *Left = leftHandGestures.front();
    *Right = rightHandGestures.front();
}

void
GestureHistory::setLeftGesture(enum Gesture NewGesture)
{
    leftHandGestures.front() = NewGesture;
}

void
GestureHistory::setRightGesture(enum Gesture NewGesture)
{
    rightHandGestures.front() = NewGesture;
}

void
GestureHistory::getSpells(vector<Spell> *LeftHandSpellList,
			  vector<Spell> *RightHandSpellList) const
{
    Spells::getSpellsForGestures(leftHandGestures, rightHandGestures, 
				 LeftHandSpellList);
    Spells::getSpellsForGestures(rightHandGestures, leftHandGestures,
				 RightHandSpellList);
}

