#ifndef _GAME_H
#define _GAME_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <vector>
#include "Player.H"

using namespace std;

class Game {
public:
    Game(int ServerFD);
    // ServerFD is FD to accept new player connections on

    enum GameState {
	PLAYERS_JOINING,
	PLAYING,
	GAME_ENDED
    };

    enum GameState getGameState() const;

    int numPlayers() const;
    int numPlayersAlive();

    int PlayersJoining();
    // Returns number of players joined for game

    void StartGame();


private:
    void addPlayer(int FD, Player *NewPlayer);

    void ApplySpells();

    void WaitForResponses(int Timeout);

    enum GameState gameState;
    map<int, Player *> players; // FD to player object mapping
    vector<BaseCreature *> creatures; // Includes players 

    int serverFD;

    static int turnTimeout;
};

#endif
