#ifndef __COMMON_H__
#define __COMMON_H__
/*
 * Copyright (C) Michael Fagan <Michael.Fagan@protocom.com.au> 2005
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include "Spells.H"
#include "protocol.h"


#define SIGNAL_ACTIVATE_LEVEL 5
#define AGENT_ACTIVATE_LEVEL 1
#define AGENT_PROP_LEVEL 5
#define AGENT_PROP_DEPTH 5
#define BRAIN_THRESHOLD 200
#define BRAIN_DECAY_THRESHOLD 10
#define BRAIN_MAX_ACTIVATION 200


class DEBUG
{
public:
        DEBUG(const char* fmt, ...)
    {
#if 0
        va_list va;
        va_start(va, fmt);
        char buf[2048];

        buf[2047] = '\0';

        vsnprintf(buf, 2047, fmt, va);

        printf("DEBUG: %s\n", buf);
        
        va_end(va);        
#endif
    } // DEBUG()

}; // class DEBUG


const char* gesture2str(Gesture g);
Gesture char2gesture(char ch);
const char* monster2str(int t);


#endif /*__COMMON_H__*/
