#ifndef __SPELLAGENTS_H__
#define __SPELLAGENTS_H__

#include "Agent.h"
#include "Spells.H"


namespace thoth
{


class SpellCastAgent : public Agent
{
public:
        SpellCastAgent(Spell sp, const string& gest, bool once = false, int rank = 0)
            : m_spell(sp), m_gestures(gest), 
              m_state_left(NULL), m_state_right(NULL),
              m_strength(gest.size() + rank + 1),
              m_enable(1), m_once(once), m_l_count(0), m_r_count(0)
    {
    } // SpellCastAgent()
    
    virtual ~SpellCastAgent()
    {
    } // ~SpellCastAgent()

    
    virtual void init();
    virtual void reset();
    virtual void signal(Signal& the_signal, int param1, int param2);

            
private:
    Spell   m_spell;
    string  m_gestures;
    char*   m_state_left;
    char*   m_state_right;
    int     m_strength;
    int     m_enable;
    bool    m_once;
    int     m_l_count;
    int     m_r_count;
    Signal* m_want_left;
    Signal* m_want_right;
    Signal* m_l_can_cast;
    Signal* m_r_can_cast;

    bool matchGesture(char ch, int pri, int sec);
	
}; // class SpellCastAgent


class GestureMux : public Agent
{
public:
    virtual ~GestureMux()
    {
    } // ~GestureMux()

    
    virtual void init();
    virtual void reset();
    virtual void signal(Signal& the_signal, int param1, int param2);
    virtual void cycle();

private:
    int         m_state[8][8];
    Signal*     m_send;
    bool        m_last_stab;


    void update(bool left, int gesture, int amt);
    void find(int& left, int& right);
    
}; // class GestureMux


class RandomAgent : public Agent
{
public:
    virtual void init();
    virtual void reset();
    virtual void signal(Signal& the_signal, int param1, int param2);

private:    
    Signal* m_want_left;
    Signal* m_want_right;

}; // class RandomAgent



class SpellDetectAgent : public Agent
{
public:
        SpellDetectAgent(Spell sp, const string& gest, int rank = 0, Spell count1 = SPL_NONE, int len = 1)
            : m_spell(sp), m_gestures(gest),
              m_state_left(NULL), m_state_right(NULL),
              m_strength(rank + 1),
              m_count1(count1), m_len(gest.size() - len), m_am_len(gest.size() - 3),
              m_l_count(0), m_r_count(0)
    {
    } // SpellDetectAgent()
    
    virtual ~SpellDetectAgent()
    {
    } // ~SpellDetectAgent()

    
    virtual void init();
    virtual void reset();
    virtual void signal(Signal& the_signal, int param1, int param2);

            
private:
    Spell   m_spell;
    string  m_gestures;
    char*   m_state_left;
    char*   m_state_right;
    int     m_strength;
    Spell   m_count1;
    int     m_len;
    int     m_am_len;
    int     m_l_count;
    int     m_r_count;
    Signal* m_want_spell;
    Signal* m_l_is_cast;
    Signal* m_r_is_cast;

    bool matchGesture(char ch, int pri, int sec);
	
}; // class SpellDetectAgent


}; // namespace thoth

#endif /*__SPELLAGENTS_H__*/
