/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <netinet/in.h>

#include "Message.H"

const int Message::headerValue = 0xDEADBEEF;
const int Message::footerValue = 0xABCDFEDA;

Message *
Message::createMessage(int Command, int DataSize)
{
    int msgSize = sizeof(Message) + DataSize + sizeof(footerValue);
    Message *msg = (Message *)malloc(msgSize);
    if (msg==NULL) {
	printf("failed to malloc %i bytes\n", msgSize);
	exit(1);
    }
    msg->header = headerValue;
    msg->length = msgSize;
    msg->command = Command;
    memcpy(msg->data + (msgSize-sizeof(Message)-sizeof(footerValue)),
	   &footerValue, sizeof(footerValue));

    assert(msg->Ok());

    return msg;
}

unsigned int
Message::dataLength() const 
{
    return length - sizeof(Message) - sizeof(footerValue);
}

bool
Message::Ok() const
{
    return header==headerValue && 
	memcmp(&footerValue, data + 
	       (length-sizeof(Message)-sizeof(footerValue)),
	       sizeof(footerValue))==0;
}

void
Message::ConvertToNetworkByteOrder(Message *Msg)
{
    int msgLength = Msg->length;

    Msg->header = htonl(Msg->header);
    Msg->length = htonl(Msg->length);
    Msg->command = htonl(Msg->command);

    int &footer = *(int*)(Msg->data 
			  + (msgLength-sizeof(Message)-sizeof(footerValue)));
    footer = htonl(footer);
}

void
Message::ConvertToHostByteOrder(Message *Msg)
{
    Msg->header = ntohl(Msg->header);
    Msg->length = ntohl(Msg->length);
    Msg->command = ntohl(Msg->command);

    int &footer = *(int*)(Msg->data 
			  + (Msg->length-sizeof(Message)-sizeof(footerValue)));
    footer = ntohl(footer);
}
