#include "Signal.h"
#include "Agent.h"
#include "common.h"

namespace thoth
{


SignalList   SIGNALS;


void Signal::signal(int param1, int param2)
{
/*
    DEBUG("Signal %s(%i:%s, %i:%s)", m_name.c_str(),
            param1, gesture2str((Gesture)param1),
            param2, gesture2str((Gesture)param2));
*/
    m_param1 = param1;
    m_param2 = param2;
    vector<Agent*>::iterator itr = m_listeners.begin();
    for( ; itr != m_listeners.end(); ++itr)
    {
        (*itr)->signal(*this, param1, param2);
    }
} // signal()


Signal* SignalList::getSignal(const string& name)
{
    MapType::iterator itr = m_data.find(name);
    if ( itr == m_data.end() ) {
        Signal* tmp = new Signal(name);
        m_data[name] = tmp;
        return tmp;
    } else {
        return (*itr).second;
    }
} // getSignal()


void SignalList::dump()
{
    DEBUG("Dumping new signals");
    MapType::iterator itr = m_data.begin();
    for( ; itr != m_data.end(); ++itr)
    {
        DEBUG("new Signal: %s", (*itr).second->getName().c_str() );
    }
} // dump()


}; // namespace thoth
