#ifndef __CLIENTDISPATCH_H__
#define __CLIENTDISPATCH_H__
/*
 * Copyright (C) Michael Fagan <Michael.Fagan@protocom.com.au> 2005
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "SCClient.H"
#include "protocol.h"
#include "Spells.H"
#include "WizardBrain.h"
#include <string>

namespace thoth
{
using std::string;


class ClientDispatch
{
public:
        ClientDispatch(const string& hostname, const string& name)
            : m_hostname(hostname), m_name(name),
              m_red_ID(-1), m_white_ID(-1), m_resistCold(false),
              m_resistHeat(false), m_red_l_hand(0), m_red_r_hand(0),
              m_disenchant(false)
    {
    } // ClientDispatch()

        ~ClientDispatch();


    void connect();

    void dispatchLoop();

    void updateCreatures();
    void updateHistory();

    void signal(const string& name, int param1 = 0, int param = 0);

    void findTarget(Spell sp, int& target);
    int findHand(bool charm);

    void correctSpell(Spell& left, Spell& right);
    int getSpellLength(Spell sp);

    
private:
    string      m_hostname;
    string      m_name;
    SCClient*   m_client;
    int         m_red_ID;
    int         m_white_ID;
    WizardBrain m_brain;
    bool        m_resistCold;
    bool        m_resistHeat;
    int         m_red_l_hand;
    int         m_red_r_hand;
    int         m_disenchant;
    
}; // class ClientDispatch


}; // namespace thoth

#endif /*__CLIENTDISPATCH_H__*/
