#!/usr/bin/env python2.3

### spells.py - part of ecar, an entry for the LCA 2005 hackfest.
### http://lca2005.linux.org.au/hackfest/
### (C) Russell Steicke, 2005.
### Licensed under GPL, see the file COPYING.



'''Details of spells.
'''

from protocol import GST_ANTISPELL, GST_CLAP, GST_FINGER, GST_FOG, GST_KNIFE, \
     GST_NOTHING, GST_PALM, GST_POINT, GST_SNAP, GST_WAVE

__all__ = ['spellTypeToName',
           'isSummoningSpell',
           'spellSequences',
           'isDefensiveSpell',
           'isOffensiveSpell',
           ]


SPL_NONE                 = 0
SPL_SHIELD               = 1
SPL_COUNTER_SPELL        = 2
SPL_COUNTER_SPELL1       = 3
SPL_MAGIC_MIRROR         = 4
SPL_DISPEL_MAGIC         = 5
SPL_RAISE_DEAD           = 6
SPL_MISSILE              = 7
SPL_FINGER_OF_DEATH      = 8
SPL_LIGHTNING_BOLT       = 9
SPL_LIGHTNING_BOLT1      = 10
SPL_CAUSE_LIGHT_WOUNDS   = 11
SPL_CAUSE_HEAVY_WOUNDS   = 12
SPL_FIREBALL             = 13
SPL_FIRESTORM            = 14
SPL_ICESTORM             = 15
SPL_AMNESIA              = 16
SPL_CONFUSION            = 17
SPL_CHARM_PERSON         = 18
SPL_CHARM_MONSTER        = 19
SPL_PARALYSIS            = 20
SPL_FEAR                 = 21
SPL_ANTI_SPELL           = 22
SPL_PROTECTION_FROM_EVIL = 23
SPL_RESIST_HEAT          = 24
SPL_RESIST_COLD          = 25
SPL_DISEASE              = 26
SPL_POISON               = 27
SPL_BLINDNESS            = 28
SPL_INVISIBILITY         = 29
SPL_HASTE                = 30
SPL_TIME_STOP            = 31
SPL_DELAYED_EFFECT       = 32
SPL_PERMANENCY           = 33
SPL_REMOVE_ENCHANTMENT   = 34
SPL_CURE_LIGHT_WOUNDS    = 35
SPL_CURE_HEAVY_WOUNDS    = 36
SPL_SUMMON_GOBLIN        = 37
SPL_SUMMON_OGRE          = 38
SPL_SUMMON_TROLL         = 39
SPL_SUMMON_GIANT         = 40
SPL_SUMMON_FIRE_ELEMENTAL= 41
SPL_SUMMON_ICE_ELEMENTAL = 42
SPL_SURRENDER            = 43
SPL_STAB                 = 44
SPL_FINAL_MARKER         = 45

_spellTypeToName = {
    SPL_NONE                 : "SPL_NONE",
    SPL_SHIELD               : "Shield",
    SPL_COUNTER_SPELL        : "Counter spell",
    SPL_COUNTER_SPELL1       : "Counter spell",
    SPL_MAGIC_MIRROR         : "Magic mirror",
    SPL_DISPEL_MAGIC         : "Dispel magic",
    SPL_RAISE_DEAD           : "Raise dead",
    SPL_CURE_LIGHT_WOUNDS    : "Cure light wounds",
    SPL_CURE_HEAVY_WOUNDS    : "Cure heavy wounds",
    SPL_MISSILE              : "Missile",
    SPL_FINGER_OF_DEATH      : "Finger of death",
    SPL_LIGHTNING_BOLT       : "Lightning bolt",
    SPL_LIGHTNING_BOLT1      : "Lightning bolt1",
    SPL_CAUSE_LIGHT_WOUNDS   : "Cause light wounds",
    SPL_CAUSE_HEAVY_WOUNDS   : "Cause heavy wounds",
    SPL_FIREBALL             : "Fireball",
    SPL_FIRESTORM            : "Firestorm",
    SPL_ICESTORM             : "Icestorm",
    SPL_AMNESIA              : "Amnesia",
    SPL_CONFUSION            : "Confusion",
    SPL_CHARM_PERSON         : "Charm person",
    SPL_CHARM_MONSTER        : "Charm monster",
    SPL_PARALYSIS            : "Paralysis",
    SPL_FEAR                 : "Fear",
    SPL_ANTI_SPELL           : "Anti spell",
    SPL_PROTECTION_FROM_EVIL : "Protection from evil",
    SPL_RESIST_HEAT          : "Resist heat",
    SPL_RESIST_COLD          : "Resist cold",
    SPL_DISEASE              : "Disease",
    SPL_POISON               : "Poison",
    SPL_BLINDNESS            : "Blindness",
    SPL_INVISIBILITY         : "Invisibility",
    SPL_HASTE                : "Haste",
    SPL_TIME_STOP            : "Time stop",
    SPL_DELAYED_EFFECT       : "Delayed effect",
    SPL_PERMANENCY           : "Permanency",
    SPL_REMOVE_ENCHANTMENT   : "Remove enchantment",
    SPL_SUMMON_GOBLIN        : "Summon goblin",
    SPL_SUMMON_OGRE          : "Summon ogre",
    SPL_SUMMON_TROLL         : "Summon troll",
    SPL_SUMMON_GIANT         : "Summon giant",
    SPL_SUMMON_FIRE_ELEMENTAL: "Summon fire elemental",
    SPL_SUMMON_ICE_ELEMENTAL : "Summon ice elemental",
    SPL_SURRENDER            : "Surrender",
    SPL_STAB                 : "Stab",
    SPL_FINAL_MARKER         : "FINAL_MARKER",
    }

def spellTypeToName(spelltype):
    try:
        if spelltype != SPL_FINAL_MARKER:
            return _spellTypeToName[spelltype]
    except KeyError:
        return "UnknownSpell%d" % spelltype

def isSummoningSpell(spelltype):
    '''Convenience method for monster summoning spells.

    For summoning spells, when the server tells us that the spell has
    been cast, it sends more information in the message; it puts a %M
    in the text that can get replaced with the monster type.  We need
    to be able to insert the correct monster type in there.  This
    function will return a monster type name for summoning spells, or
    None.'''
    if spelltype == SPL_SUMMON_GOBLIN:
        return "Goblin"
    elif spelltype == SPL_SUMMON_OGRE:
        return "Ogre"
    elif spelltype == SPL_SUMMON_TROLL:
        return "Troll"
    elif spelltype == SPL_SUMMON_GIANT:
        return "Giant"
    elif spelltype == SPL_SUMMON_FIRE_ELEMENTAL:
        return "Fire elemental"
    elif spelltype == SPL_SUMMON_ICE_ELEMENTAL:
        return "Ice elemental"
    else:
        return None


spellSequences = {
    SPL_DISPEL_MAGIC         : ((GST_CLAP, GST_CLAP), GST_POINT, GST_PALM, GST_WAVE),
    SPL_SUMMON_FIRE_ELEMENTAL: ((GST_CLAP, GST_CLAP), GST_SNAP, GST_WAVE, GST_WAVE, GST_SNAP),
    SPL_SUMMON_ICE_ELEMENTAL : ((GST_CLAP, GST_CLAP), GST_SNAP, GST_WAVE, GST_WAVE, GST_SNAP),
    SPL_MAGIC_MIRROR         : ((GST_CLAP, GST_CLAP), (GST_WAVE, GST_WAVE)),
    SPL_LIGHTNING_BOLT1      : (GST_POINT, GST_FINGER, GST_FINGER, GST_POINT, GST_POINT),
    SPL_CURE_HEAVY_WOUNDS    : (GST_POINT, GST_FINGER, GST_PALM, GST_WAVE),
    SPL_CURE_LIGHT_WOUNDS    : (GST_POINT, GST_FINGER, GST_WAVE),
    SPL_AMNESIA              : (GST_POINT, GST_PALM, GST_PALM),
    SPL_CONFUSION            : (GST_POINT, GST_SNAP, GST_FINGER),
    SPL_DISEASE              : (GST_POINT, GST_SNAP, GST_FINGER, GST_FINGER, GST_FINGER, (GST_CLAP, GST_CLAP)),
    SPL_BLINDNESS            : (GST_POINT, GST_WAVE, GST_FINGER, GST_FINGER, (GST_POINT, GST_POINT)),
    SPL_DELAYED_EFFECT       : (GST_POINT, GST_WAVE, GST_SNAP, GST_SNAP, GST_SNAP, GST_PALM),
    SPL_RAISE_DEAD           : (GST_POINT, GST_WAVE, GST_WAVE, GST_FINGER, GST_WAVE, (GST_CLAP, GST_CLAP)),
    SPL_POISON               : (GST_POINT, GST_WAVE, GST_WAVE, GST_FINGER, GST_WAVE, GST_POINT),
    SPL_PARALYSIS            : (GST_FINGER, GST_FINGER, GST_FINGER),
    SPL_SUMMON_TROLL         : (GST_FINGER, GST_PALM, GST_SNAP, GST_FINGER, GST_WAVE),
    SPL_FIREBALL             : (GST_FINGER, GST_SNAP, GST_SNAP, GST_POINT, GST_POINT),
    SPL_SHIELD               : (GST_PALM),
    SPL_SURRENDER            : ((GST_PALM, GST_PALM),),
    SPL_REMOVE_ENCHANTMENT   : (GST_PALM, GST_POINT, GST_WAVE, GST_PALM),
    SPL_INVISIBILITY         : (GST_PALM, GST_PALM, (GST_WAVE, GST_WAVE), (GST_SNAP, GST_SNAP)),
    SPL_CHARM_MONSTER        : (GST_PALM, GST_SNAP, GST_POINT, GST_POINT),
    SPL_CHARM_PERSON         : (GST_PALM, GST_SNAP, GST_POINT, GST_FINGER),
    SPL_SUMMON_OGRE          : (GST_PALM, GST_SNAP, GST_FINGER, GST_WAVE),
    SPL_FINGER_OF_DEATH      : (GST_PALM, GST_WAVE, GST_PALM, GST_FINGER, GST_SNAP, GST_SNAP, GST_SNAP, GST_POINT),
    SPL_HASTE                : (GST_PALM, GST_WAVE, GST_PALM, GST_WAVE, GST_WAVE, (GST_CLAP, GST_CLAP)),
    SPL_MISSILE              : (GST_SNAP, GST_POINT),
    SPL_SUMMON_GOBLIN        : (GST_SNAP, GST_FINGER, GST_WAVE),
    SPL_ANTI_SPELL           : (GST_SNAP, GST_PALM, GST_FINGER),
    SPL_PERMANENCY           : (GST_SNAP, GST_PALM, GST_FINGER, GST_PALM, GST_SNAP, GST_POINT, GST_WAVE),
    SPL_TIME_STOP            : (GST_SNAP, GST_PALM, GST_PALM, (GST_CLAP, GST_CLAP)),
    SPL_LIGHTNING_BOLT       : (GST_WAVE, GST_POINT, GST_POINT, (GST_CLAP, GST_CLAP)),
    SPL_CAUSE_LIGHT_WOUNDS   : (GST_WAVE, GST_FINGER, GST_PALM),
    SPL_SUMMON_GIANT         : (GST_WAVE, GST_FINGER, GST_PALM, GST_SNAP, GST_FINGER, GST_WAVE),
    SPL_CAUSE_HEAVY_WOUNDS   : (GST_WAVE, GST_PALM, GST_FINGER, GST_POINT),
    SPL_COUNTER_SPELL        : (GST_WAVE, GST_PALM, GST_PALM),
    SPL_ICESTORM             : (GST_WAVE, GST_SNAP, GST_SNAP, (GST_CLAP, GST_CLAP)),
    SPL_RESIST_HEAT          : (GST_WAVE, GST_WAVE, GST_FINGER, GST_PALM),
    SPL_PROTECTION_FROM_EVIL : (GST_WAVE, GST_WAVE, GST_PALM),
    SPL_COUNTER_SPELL1       : (GST_WAVE, GST_WAVE, GST_SNAP),
    }

_defensiveSpells = {
    SPL_MAGIC_MIRROR : 1,
    SPL_CURE_HEAVY_WOUNDS : 1,
    SPL_CURE_LIGHT_WOUNDS : 1,
    SPL_SHIELD : 1,
    SPL_REMOVE_ENCHANTMENT : 1,
    SPL_INVISIBILITY : 1,
    SPL_HASTE : 1,
    SPL_COUNTER_SPELL : 1,
    SPL_COUNTER_SPELL1 : 1,
    SPL_RESIST_HEAT : 1,
    SPL_PROTECTION_FROM_EVIL : 1,
    SPL_SUMMON_FIRE_ELEMENTAL : 1,
    SPL_SUMMON_ICE_ELEMENTAL : 1,
    SPL_SUMMON_OGRE : 1,
    SPL_SUMMON_TROLL : 1,
    SPL_SUMMON_GIANT : 1,
    SPL_SUMMON_GOBLIN : 1,
    SPL_RAISE_DEAD : 1,
    }

_offensiveSpells = {
    SPL_ANTI_SPELL : 1,
    SPL_DISPEL_MAGIC : 1,
    SPL_LIGHTNING_BOLT : 1,
    SPL_LIGHTNING_BOLT1 : 1,
    SPL_AMNESIA : 1,
    SPL_CONFUSION : 1,
    SPL_DISEASE : 1,
    SPL_BLINDNESS : 1,
    SPL_POISON : 1,
    SPL_PARALYSIS : 1,
    SPL_FIREBALL : 1,
    SPL_CHARM_MONSTER : 1,
    SPL_CHARM_PERSON : 1,
    SPL_FINGER_OF_DEATH : 1,
    SPL_MISSILE : 1,
    SPL_TIME_STOP : 1,
    SPL_CAUSE_LIGHT_WOUNDS : 1,
    SPL_CAUSE_HEAVY_WOUNDS : 1,
    SPL_ICESTORM : 1,
    SPL_PERMANENCY : 1,
    SPL_STAB : 1,
    }


def isDefensiveSpell(spell):
    return _defensiveSpells.has_key(spell)


def isOffensiveSpell(spell):
    return _offensiveSpells.has_key(spell)


for key in locals().keys():
    if key.startswith('SPL_'):
        __all__.append(key)


### arch-tag: 95247b8d-ee44-4c73-b43a-69134bb1f136

