#!/usr/bin/env python2.3

# vim: set shiftwidth=4 tabstop=4 expandtab smartindent textwidth=80:

# Part of ecar, an entry for the LCA 2005 hackfest:
# http://lca2005.linux.org.au/hackfest/
# (C) 2005, Russell Steicke, <russells@adelie.cx>
# Licensed under GPL, see the file COPYING.


# Make us faster, if available.
try:
    import psyco
    psyco.full()
except ImportError, reason:
    pass

# Local stuff
from hflib.protocol import *


class Creature:

    def __init__(self, name):
        self.name = name
        self.health = -1
        self.state = -1

    def getHealth(self):
        return self.health

    def setHealth(self, health):
        self.health = health

    def getState(self):
        return self.state

    def setState(self, state):
        self.state = state

    def getName(self):
        return self.name

    def setName(self, name):
        self.name = name

    def setNumber(self, number):
        self.number = number

    def getNumber(self):
        return self.number

    def __str__(self):
        return "<Creature:%s>" % (self.name,)


# Local variables: ***
# mode:python ***
# py-indent-offset:4 ***
# fill-column:80 ***
# End: ***
### arch-tag: 012944cb-6636-4589-9dd8-357a4e627afd

