enum Spell {
  SPL_NONE,
  SPL_SHIELD,
  SPL_COUNTER_SPELL,
  SPL_COUNTER_SPELL1,
  SPL_MAGIC_MIRROR,
  SPL_DISPEL_MAGIC,
  SPL_RAISE_DEAD,
  SPL_MISSILE,
  SPL_FINGER_OF_DEATH,
  SPL_LIGHTNING_BOLT,
  SPL_LIGHTNING_BOLT1,
  SPL_CAUSE_LIGHT_WOUNDS,
  SPL_CAUSE_HEAVY_WOUNDS,
  SPL_FIREBALL,
  SPL_FIRESTORM,
  SPL_ICESTORM,
  SPL_AMNESIA,
  SPL_CONFUSION,
  SPL_CHARM_PERSON,
  SPL_CHARM_MONSTER,
  SPL_PARALYSIS,
  SPL_FEAR,
  SPL_ANTI_SPELL,
  SPL_PROTECTION_FROM_EVIL,
  SPL_RESIST_HEAT,
  SPL_RESIST_COLD,
  SPL_DISEASE,
  SPL_POISON,
  SPL_BLINDNESS,
  SPL_INVISIBILITY,
  SPL_HASTE,
  SPL_TIME_STOP,
  SPL_DELAYED_EFFECT,
  SPL_PERMANENCY,
  SPL_REMOVE_ENCHANTMENT,
  SPL_CURE_LIGHT_WOUNDS,
  SPL_CURE_HEAVY_WOUNDS,
  SPL_SUMMON_GOBLIN,
  SPL_SUMMON_OGRE,
  SPL_SUMMON_TROLL,
  SPL_SUMMON_GIANT,
  SPL_SUMMON_FIRE_ELEMENTAL,
  SPL_SUMMON_ICE_ELEMENTAL,
  SPL_SURRENDER,
  SPL_STAB,
  SPL_FINAL_MARKER
};

extern char *spell_name[SPL_FINAL_MARKER];

/* in what order should we apply the spells */
unsigned char spell_order[SPL_FINAL_MARKER];

/* do we usually apply this spell to ourself (0) or someone else (1)? */
extern unsigned char spell_who[SPL_FINAL_MARKER];

/* if we would usually apply this spell to someone, is it worth
 * considering applying this to the other person?  (0 no, 1 yes)
 */
unsigned char spell_either[SPL_FINAL_MARKER];

/* should we try applying this spell only on wizards (0), only on
 * monsters (1), or both (2)?
 */
unsigned char spell_monster[SPL_FINAL_MARKER];

/* used as a first guess to order moves */
extern unsigned char spell_score[SPL_FINAL_MARKER];

/* the GestureLists that can be used to invoke a particular spell */
#define SPL_MATCH_MAX 78
#define SPL_MATCH_LEFT_MAX 40
#define SPL_MATCH_RIGHT_MAX 38
extern int spell_match_type[SPL_MATCH_MAX];
extern GestureList spell_match[SPL_MATCH_MAX];
extern GestureList spell_match_mask[SPL_MATCH_MAX];

/* LH/RH gestured-spells separated (both-hand-only spells will be in LH) */
extern int spell_match_left_type[SPL_MATCH_LEFT_MAX];
extern GestureList spell_match_left[SPL_MATCH_LEFT_MAX];
extern GestureList spell_match_left_mask[SPL_MATCH_LEFT_MAX];

extern int spell_match_right_type[SPL_MATCH_RIGHT_MAX];
extern GestureList spell_match_right[SPL_MATCH_RIGHT_MAX];
extern GestureList spell_match_right_mask[SPL_MATCH_RIGHT_MAX];

/* The matching spells from get_spellpair_list() are returned in a
 * *SpellPair.  MSWord = LH spell, LSWord = RH spell.  At most 6
 * spells could need to be returned from get_spellpair_list():
 * - Shield + Counter Spell
 * - Shield + Summon Elemental
 * - Cause light wounds + Counter Spell
 * - Cause light wounds + Summon Elemental
 * - Resist heat + Counter Spell
 * - Resist heat + Summon Elemental
 * The MSByte of either word gets used later on (not set by
 * get_spellpair_list()) to indicate who the spell should be applied
 * to:
 * 000mwwww
 * w: what wizard to apply the spell to (0: us, 1-15: someone else)
 * m: 0: apply to the wizard, 1: apply to one of their monsters
 */
#define MAX_SPELL_LIST 6
typedef unsigned int SpellPair;

#define make_spell_pair(a, b) (((a) << 16) | (b))

void init_spells(void);
void get_spellpair_list(GestureList gl, SpellPair *spells);
