//#define DEBUG_INIT_SPELL_FINDER
//#define DEBUG_GET_SPELLPAIR_LIST
//#define DEBUG_GET_SPELL_LIST

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gestures.h"
#include "spells.h"

char *spell_name[SPL_FINAL_MARKER] = {
  "None",
  "Shield",
  "Counter Spell",
  "Counter Spell",
  "Magic Mirror",
  "Dispel Magic",
  "Raise Dead",
  "Missile",
  "Finger of Death",
  "Lightning Bolt",
  "Lightning Bolt",
  "Cause Light Wounds",
  "Cause Heavy Wounds",
  "Fireball",
  "Firestorm",
  "Icestorm",
  "Amnesia",
  "Confusion",
  "Charm person",
  "Charm monster",
  "Paralysis",
  "Fear",
  "Anti-spell",
  "Protection From Evil",
  "Resist Heat",
  "Resist Cold",
  "Disease",
  "Poison",
  "Blindness",
  "Invisibility",
  "Haste",
  "Time Stop",
  "Delayed Effect",
  "Permanency",
  "Remove Enchantment",
  "Cure Light Wounds",
  "Cure Heavy Wounds",
  "Summon Goblin",
  "Summon Ogre",
  "Summon Troll",
  "Summon Giant",
  "Summon Fire Elemental",
  "Summon Ice Elemental",
  "Surrender",
  "Stab"
};

unsigned char spell_order[SPL_FINAL_MARKER];

static unsigned char spell_order_inverse[SPL_FINAL_MARKER] = {
  SPL_DISPEL_MAGIC,         // before everything
  SPL_COUNTER_SPELL,        // before magic mirror
  SPL_COUNTER_SPELL1,
  SPL_MAGIC_MIRROR,         // before nearly anything
  SPL_FINGER_OF_DEATH,      // before raise dead
  SPL_SHIELD,               // before stab, missile
  SPL_PROTECTION_FROM_EVIL, // next to shield
  SPL_LIGHTNING_BOLT,
  SPL_LIGHTNING_BOLT1,
  SPL_CAUSE_LIGHT_WOUNDS,
  SPL_CAUSE_HEAVY_WOUNDS,
  SPL_FIREBALL,
  SPL_FIRESTORM,
  SPL_ICESTORM,
  SPL_AMNESIA,
  SPL_CONFUSION,
  SPL_CHARM_PERSON,
  SPL_CHARM_MONSTER,
  SPL_PARALYSIS,
  SPL_FEAR,
  SPL_ANTI_SPELL,
  SPL_RESIST_HEAT,
  SPL_RESIST_COLD,
  SPL_DISEASE,
  SPL_POISON,
  SPL_BLINDNESS,
  SPL_INVISIBILITY,
  SPL_HASTE,
  SPL_TIME_STOP,
  SPL_CURE_LIGHT_WOUNDS,
  SPL_CURE_HEAVY_WOUNDS,
  SPL_REMOVE_ENCHANTMENT,  // after enchantments
  SPL_DELAYED_EFFECT,
  SPL_PERMANENCY,
  SPL_SUMMON_GOBLIN,
  SPL_SUMMON_OGRE,
  SPL_SUMMON_TROLL,
  SPL_SUMMON_GIANT,
  SPL_SUMMON_FIRE_ELEMENTAL,
  SPL_SUMMON_ICE_ELEMENTAL,
  SPL_SURRENDER,
  SPL_MISSILE,
  SPL_STAB,
  SPL_RAISE_DEAD,
  SPL_NONE,
};

unsigned char spell_who[SPL_FINAL_MARKER] = {
  0, // SPL_NONE
  0, // SPL_SHIELD
  0, // SPL_COUNTER_SPELL
  0, // SPL_COUNTER_SPELL1
  0, // SPL_MAGIC_MIRROR
  0, // SPL_DISPEL_MAGIC
  0, // SPL_RAISE_DEAD
  1, // SPL_MISSILE
  1, // SPL_FINGER_OF_DEATH
  1, // SPL_LIGHTNING_BOLT
  1, // SPL_LIGHTNING_BOLT1
  1, // SPL_CAUSE_LIGHT_WOUNDS
  1, // SPL_CAUSE_HEAVY_WOUNDS
  1, // SPL_FIREBALL
  1, // SPL_FIRESTORM
  1, // SPL_ICESTORM
  1, // SPL_AMNESIA
  1, // SPL_CONFUSION
  1, // SPL_CHARM_PERSON
  1, // SPL_CHARM_MONSTER
  1, // SPL_PARALYSIS
  1, // SPL_FEAR
  1, // SPL_ANTI_SPELL
  0, // SPL_PROTECTION_FROM_EVIL
  0, // SPL_RESIST_HEAT
  0, // SPL_RESIST_COLD
  1, // SPL_DISEASE
  1, // SPL_POISON
  1, // SPL_BLINDNESS
  0, // SPL_INVISIBILITY
  0, // SPL_HASTE
  0, // SPL_TIME_STOP
  0, // SPL_DELAYED_EFFECT
  0, // SPL_PERMANENCY
  0, // SPL_REMOVE_ENCHANTMENT
  0, // SPL_CURE_LIGHT_WOUNDS
  0, // SPL_CURE_HEAVY_WOUNDS
  0, // SPL_SUMMON_GOBLIN
  0, // SPL_SUMMON_OGRE
  0, // SPL_SUMMON_TROLL
  0, // SPL_SUMMON_GIANT
  0, // SPL_SUMMON_FIRE_ELEMENTAL
  0, // SPL_SUMMON_ICE_ELEMENTAL
  0, // SPL_SURRENDER
  1  // SPL_STAB
};

unsigned char spell_either[SPL_FINAL_MARKER] = {
  0, // SPL_NONE
  0, // SPL_SHIELD
  1, // SPL_COUNTER_SPELL        - eg. may want to prevent magic mirror,
  1, // SPL_COUNTER_SPELL1         remove enchantment, or a summon spell
  0, // SPL_MAGIC_MIRROR
  0, // SPL_DISPEL_MAGIC
  0, // SPL_RAISE_DEAD
  0, // SPL_MISSILE
  0, // SPL_FINGER_OF_DEATH
  0, // SPL_LIGHTNING_BOLT
  0, // SPL_LIGHTNING_BOLT1
  0, // SPL_CAUSE_LIGHT_WOUNDS
  0, // SPL_CAUSE_HEAVY_WOUNDS
  0, // SPL_FIREBALL
  0, // SPL_FIRESTORM
  0, // SPL_ICESTORM
  0, // SPL_AMNESIA
  0, // SPL_CONFUSION
  0, // SPL_CHARM_PERSON
  0, // SPL_CHARM_MONSTER
  0, // SPL_PARALYSIS
  0, // SPL_FEAR
  0, // SPL_ANTI_SPELL
  0, // SPL_PROTECTION_FROM_EVIL
  1, // SPL_RESIST_HEAT          - can destroy other wizard's fire elemental
  1, // SPL_RESIST_COLD          - can destroy other wizard's ice elemental
  0, // SPL_DISEASE
  0, // SPL_POISON
  0, // SPL_BLINDNESS
  1, // SPL_INVISIBILITY         - can destroy other wizard's monsters
  0, // SPL_HASTE
  0, // SPL_TIME_STOP
  0, // SPL_DELAYED_EFFECT
  0, // SPL_PERMANENCY
  1, // SPL_REMOVE_ENCHANTMENT   - enchantments can be good or bad
  0, // SPL_CURE_LIGHT_WOUNDS
  0, // SPL_CURE_HEAVY_WOUNDS
  0, // SPL_SUMMON_GOBLIN
  0, // SPL_SUMMON_OGRE
  0, // SPL_SUMMON_TROLL
  0, // SPL_SUMMON_GIANT
  0, // SPL_SUMMON_FIRE_ELEMENTAL
  0, // SPL_SUMMON_ICE_ELEMENTAL
  0, // SPL_SURRENDER
  0  // SPL_STAB
};

unsigned char spell_monster[SPL_FINAL_MARKER] = {
  0, // SPL_NONE
  0, // SPL_SHIELD
  0, // SPL_COUNTER_SPELL
  0, // SPL_COUNTER_SPELL1
  0, // SPL_MAGIC_MIRROR
  0, // SPL_DISPEL_MAGIC
  0, // SPL_RAISE_DEAD
  2, // SPL_MISSILE
  0, // SPL_FINGER_OF_DEATH
  2, // SPL_LIGHTNING_BOLT
  2, // SPL_LIGHTNING_BOLT1
  2, // SPL_CAUSE_LIGHT_WOUNDS
  2, // SPL_CAUSE_HEAVY_WOUNDS
  2, // SPL_FIREBALL
  0, // SPL_FIRESTORM
  0, // SPL_ICESTORM
  0, // SPL_AMNESIA
  0, // SPL_CONFUSION
  0, // SPL_CHARM_PERSON
  1, // SPL_CHARM_MONSTER
  0, // SPL_PARALYSIS
  0, // SPL_FEAR
  0, // SPL_ANTI_SPELL
  0, // SPL_PROTECTION_FROM_EVIL
  2, // SPL_RESIST_HEAT          - can destroy other wizard's fire elemental
  2, // SPL_RESIST_COLD          - can destroy other wizard's ice elemental
  0, // SPL_DISEASE
  0, // SPL_POISON
  2, // SPL_BLINDNESS            - can destroy other wizard's monsters
  2, // SPL_INVISIBILITY         - can destroy other wizard's monsters
  0, // SPL_HASTE
  0, // SPL_TIME_STOP
  0, // SPL_DELAYED_EFFECT
  0, // SPL_PERMANENCY
  0, // SPL_REMOVE_ENCHANTMENT
  0, // SPL_CURE_LIGHT_WOUNDS
  0, // SPL_CURE_HEAVY_WOUNDS
  0, // SPL_SUMMON_GOBLIN
  0, // SPL_SUMMON_OGRE
  0, // SPL_SUMMON_TROLL
  0, // SPL_SUMMON_GIANT
  0, // SPL_SUMMON_FIRE_ELEMENTAL
  0, // SPL_SUMMON_ICE_ELEMENTAL
  0, // SPL_SURRENDER
  0  // SPL_STAB
};

unsigned char spell_score[SPL_FINAL_MARKER] = {
  0, // SPL_NONE
  1, // SPL_SHIELD
  1, // SPL_COUNTER_SPELL
  1, // SPL_COUNTER_SPELL1
  1, // SPL_MAGIC_MIRROR
  1, // SPL_DISPEL_MAGIC
  0, // SPL_RAISE_DEAD
  1, // SPL_MISSILE
  9, // SPL_FINGER_OF_DEATH
  5, // SPL_LIGHTNING_BOLT
  5, // SPL_LIGHTNING_BOLT1
  2, // SPL_CAUSE_LIGHT_WOUNDS
  3, // SPL_CAUSE_HEAVY_WOUNDS
  1, // SPL_FIREBALL
  5, // SPL_FIRESTORM
  5, // SPL_ICESTORM
  2, // SPL_AMNESIA
  2, // SPL_CONFUSION
  2, // SPL_CHARM_PERSON
  2, // SPL_CHARM_MONSTER
  2, // SPL_PARALYSIS
  2, // SPL_FEAR
  1, // SPL_ANTI_SPELL
  1, // SPL_PROTECTION_FROM_EVIL
  1, // SPL_RESIST_HEAT
  1, // SPL_RESIST_COLD
  1, // SPL_DISEASE
  1, // SPL_POISON
  1, // SPL_BLINDNESS
  1, // SPL_INVISIBILITY
  0, // SPL_HASTE
  0, // SPL_TIME_STOP
  0, // SPL_DELAYED_EFFECT
  0, // SPL_PERMANENCY
  1, // SPL_REMOVE_ENCHANTMENT
  1, // SPL_CURE_LIGHT_WOUNDS
  2, // SPL_CURE_HEAVY_WOUNDS
  1, // SPL_SUMMON_GOBLIN
  2, // SPL_SUMMON_OGRE
  3, // SPL_SUMMON_TROLL
  4, // SPL_SUMMON_GIANT
  5, // SPL_SUMMON_FIRE_ELEMENTAL
  5, // SPL_SUMMON_ICE_ELEMENTAL
  0, // SPL_SURRENDER
  1  // SPL_STAB
};

/* the GestureLists that can be used to invoke a particular spell */
int spell_match_type[SPL_MATCH_MAX];
GestureList spell_match[SPL_MATCH_MAX];
GestureList spell_match_mask[SPL_MATCH_MAX];

/* LH/RH gestured-spells separated (both-hand-only spells will be in LH) */
int spell_match_left_type[SPL_MATCH_LEFT_MAX];
GestureList spell_match_left[SPL_MATCH_LEFT_MAX];
GestureList spell_match_left_mask[SPL_MATCH_LEFT_MAX];

int spell_match_right_type[SPL_MATCH_RIGHT_MAX];
GestureList spell_match_right[SPL_MATCH_RIGHT_MAX];
GestureList spell_match_right_mask[SPL_MATCH_RIGHT_MAX];

/* given n GesturePairs, make a GestureList */
#define make_gl_2(a, b) (((a) << 8) | (b))
#define make_gl_3(a, b, c) (((a) << 16) | ((b) <<  8) | (c))
#define make_gl_4(a, b, c, d) (((a) << 24) | ((b) << 16) | ((c) <<  8) | (d))
#define make_gl_5(a, b, c, d, e) \
  (((a) << 32) | ((b) << 24) | ((c) << 16) | ((d) <<  8) | (e))
#define make_gl_6(a, b, c, d, e, f) \
  (((a) << 40) | ((b) << 32) | ((c) << 24) | ((d) << 16) | ((e) <<  8) | (f))
#define make_gl_7(a, b, c, d, e, f, g) \
  (((a) << 48) | ((b) << 40) | ((c) << 32) | ((d) << 24) | \
   ((e) << 16) | ((f) <<  8) |  (g))
#define make_gl_8(a, b, c, d, e, f, g, h) \
  (((a) << 56) | ((b) << 48) | ((c) << 40) | ((d) << 32) | \
   ((e) << 24) | ((f) << 16) | ((g) <<  8) |  (h))

/* Given a GestureList, returns a bitmask that can be used to match a
 * spell.  Eg. given make_gp(GST_WAVE, GST_NOTHING), it will
 * return make_gp(GST_MASK, GST_NOTHING)
 */
#define make_gpmask(a) ( \
  make_gp(               \
    RH( ((LH(a)) << 3) | \
        ((LH(a)) << 2) | \
        ((LH(a)) << 1) | \
         (LH(a))       | \
        ((LH(a)) >> 1) | \
        ((LH(a)) >> 2) | \
        ((LH(a)) >> 3)   \
      ),                 \
    RH(                  \
        ((RH(a)) << 3) | \
        ((RH(a)) << 2) | \
        ((RH(a)) << 1) | \
         (RH(a))       | \
        ((RH(a)) >> 1) | \
        ((RH(a)) >> 2) | \
        ((RH(a)) >> 3)   \
      )                  \
  )                      \
)

/* #defines to help init_spell_match() */
#define init_spell_left() \
  spell_match_left_type[i_left] = spell_match_type[i - 1];  \
  spell_match_left[i_left] = spell_match[i - 1];            \
  spell_match_left_mask[i_left] = spell_match_mask[i - 1];  \
  i_left++

#define init_spell1(spell, a)                          \
  spell_match_type[i] = spell;                         \
  spell_match[i] = a;                                  \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell2(spell, a, b)                       \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_2(a, b);                    \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell3(spell, a, b, c)                    \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_3(a, b, c);                 \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell4(spell, a, b, c, d)                 \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_4(a, b, c, d);              \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell5(spell, a, b, c, d, e)              \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_5(a, b, c, d, e);           \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell6(spell, a, b, c, d, e, f)           \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_6(a, b, c, d, e, f);        \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell7(spell, a, b, c, d, e, f, g)        \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_7(a, b, c, d, e, f, g);     \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define init_spell8(spell, a, b, c, d, e, f, g, h)     \
  spell_match_type[i] = spell;                         \
  spell_match[i] = make_gl_8(a, b, c, d, e, f, g, h);  \
  spell_match_mask[i] = make_gpmask(spell_match[i]);   \
  i++;                                                 \
  init_spell_left()

#define repeat_spell_swap_hands()                            \
  spell_match_type[i] = spell_match_type[i - 1];             \
  spell_match[i]      = swap_hands(spell_match[i - 1]);      \
  spell_match_mask[i] = swap_hands(spell_match_mask[i - 1]); \
  i++;                                                       \
  spell_match_right_type[i_right] = spell_match_type[i - 1]; \
  spell_match_right[i_right] = spell_match[i - 1];           \
  spell_match_right_mask[i_right] = spell_match_mask[i - 1]; \
  i_right++

/* mask out one or two GesturePairs (GST_MASK_2 is used for looking up
 * spells quickly)
 */
#define GST_MASK_1 0xFF
#define GST_MASK_2 0xFFFF

static void init_spell_match(void) {
  int i = 0, i_left = 0, i_right = 0;

  /* the ordering here must have trumping spells before trumped spells */

  init_spell3(SPL_COUNTER_SPELL,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_COUNTER_SPELL1,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell1(SPL_SHIELD,
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell2(SPL_MAGIC_MIRROR,
              make_gp(GST_CLAP, GST_CLAP),
              make_gp(GST_WAVE, GST_WAVE));

  init_spell4(SPL_DISPEL_MAGIC,
              make_gp(GST_CLAP, GST_CLAP),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell6(SPL_RAISE_DEAD,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell3(SPL_CURE_LIGHT_WOUNDS,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_CURE_HEAVY_WOUNDS,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell8(SPL_FINGER_OF_DEATH,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell2(SPL_MISSILE,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_LIGHTNING_BOLT,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_LIGHTNING_BOLT1,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell3(SPL_CAUSE_LIGHT_WOUNDS,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_CAUSE_HEAVY_WOUNDS,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_FIREBALL,
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_FIRESTORM,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell4(SPL_ICESTORM,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell3(SPL_AMNESIA,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_CONFUSION,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_CHARM_PERSON,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_CHARM_MONSTER,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_PARALYSIS,
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_FEAR,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_ANTI_SPELL,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_PROTECTION_FROM_EVIL,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_RESIST_HEAT,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_RESIST_COLD,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell6(SPL_DISEASE,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell6(SPL_POISON,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_BLINDNESS,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_POINT, GST_POINT));
  repeat_spell_swap_hands();

  init_spell4(SPL_INVISIBILITY,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_WAVE),
              make_gp(GST_SNAP, GST_SNAP));
  repeat_spell_swap_hands();

#if 0
  /* these have not been implemented in sc */
  init_spell6(SPL_HASTE,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell4(SPL_TIME_STOP,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_CLAP, GST_CLAP));
  repeat_spell_swap_hands();

  init_spell6(SPL_DELAYED_EFFECT,
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell7(SPL_PERMANENCY,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();
#endif

  init_spell4(SPL_REMOVE_ENCHANTMENT,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_POINT, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell6(SPL_SUMMON_GIANT,
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_SUMMON_TROLL,
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell4(SPL_SUMMON_OGRE,
              make_gp(GST_PALM, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell3(SPL_SUMMON_GOBLIN,
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_FINGER, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_SUMMON_FIRE_ELEMENTAL,
              make_gp(GST_CLAP, GST_CLAP),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell5(SPL_SUMMON_ICE_ELEMENTAL,
              make_gp(GST_CLAP, GST_CLAP),
              make_gp(GST_SNAP, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_WAVE, GST_NOTHING),
              make_gp(GST_SNAP, GST_NOTHING));
  repeat_spell_swap_hands();

  init_spell1(SPL_SURRENDER,
              make_gp(GST_PALM, GST_PALM));

  init_spell1(SPL_STAB,
              make_gp(GST_KNIFE, GST_NOTHING));
  repeat_spell_swap_hands();

  if (i != SPL_MATCH_MAX) {
    printf("Error in init_spells: SPL_MATCH_MAX should be %d not %d\n",
           i, SPL_MATCH_MAX);
    exit(1);
  }
  if (i_left != SPL_MATCH_LEFT_MAX) {
    printf("Error in init_spells: SPL_MATCH_LEFT_MAX should be %d not %d\n",
           i_left, SPL_MATCH_LEFT_MAX);
    exit(1);
  }
  if (i_right != SPL_MATCH_RIGHT_MAX) {
    printf("Error in init_spells: SPL_MATCH_RIGHT_MAX should be %d not %d\n",
           i_right, SPL_MATCH_RIGHT_MAX);
    exit(1);
  }
}

/* Index from two gestures:
 *   make_gl_2(make_gp(l1, r1), make_gp(l2, r2))
 * into spell_match for those spells that end with those two gestures.
 * -1 is used to terminate the list.  The maximum number of spells on
 * one hand that end with any two given gestures is 5 (Cure Light
 * Wounds plus Summon Goblin/Ogre/Troll/Giant).
 *
 * This lets us look up what spells corresponds to a GestureList with
 * as little work as possible.
 */
#define MAX_SPELL_FINDER_L 5
#define MAX_SPELL_FINDER_R 5
signed char spell_finder_l[65536][MAX_SPELL_FINDER_L + 1];
signed char spell_finder_r[65536][MAX_SPELL_FINDER_R + 1];

static void init_spell_finder(void) {
  int l1, r1, l2, r2, i;
  int max_count_l = 0, max_count_r = 0;

  memset(spell_finder_l, -1, sizeof(spell_finder_l));
  memset(spell_finder_r, -1, sizeof(spell_finder_r));

  /* each first LH gesture */
  for (l1 = 0; l1 < GST_FINAL_MARKER; l1++) {
    /* each first RH gesture */
    for (r1 = 0; r1 < GST_FINAL_MARKER; r1++) {

      /* surrender couldn't have happened here */
      if ((l1 == r1) && (r1 == GST_PALM)) {
        continue;
      }

      /* each second LH gesture */
      for (l2 = 0; l2 < GST_FINAL_MARKER; l2++) {
        /* each second RH gesture */
        for (r2 = 0; r2 < GST_FINAL_MARKER; r2++) {

          int count_l = 0, count_r = 0;

          GestureList gl = make_gl_2(make_gp(l1, r1),
                                     make_gp(l2, r2));

          /* if surrender, don't consider any other gestures */
          if ((l2 == r2) && (r2 == GST_PALM)) {
            /* surrender is a left-handed spell */
            for (i = 0; i < SPL_MATCH_LEFT_MAX; i++) {
              if (spell_match_left_type[i] == SPL_SURRENDER) {
                spell_finder_l[gl][count_l++] = i;
              }
            }

            continue;
          }

          /* each LH spell gesturelist */
          for (i = 0; i < SPL_MATCH_LEFT_MAX; i++) {
            if ((gl & spell_match_left_mask[i]) ==
                (spell_match_left[i] & GST_MASK_2)) {
#ifdef DEBUG_INIT_SPELL_FINDER
              printf("%c%c %c%c %s %lld\n",
                     gesture_print[l1], gesture_print[r1],
                     gesture_print[l2], gesture_print[r2],
                     spell_name[spell_match_left_type[i]], gl);
#endif
              spell_finder_l[gl][count_l++] = i;
            }
          }

          if (count_l > max_count_l) {
            max_count_l = count_l;
#ifdef DEBUG_INIT_SPELL_FINDER
            printf("left max is now %d\n", max_count_l);
#endif
          }

          /* each RH spell gesturelist */
          for (i = 0; i < SPL_MATCH_RIGHT_MAX; i++) {
            if ((gl & spell_match_right_mask[i]) ==
                (spell_match_right[i] & GST_MASK_2)) {
#ifdef DEBUG_INIT_SPELL_FINDER
              printf("%c%c %c%c %s %lld\n",
                     gesture_print[l1], gesture_print[r1],
                     gesture_print[l2], gesture_print[r2],
                     spell_name[spell_match_right_type[i]], gl);
#endif
              spell_finder_r[gl][count_r++] = i;
            }
          }

          if (count_r > max_count_r) {
            max_count_r = count_r;
#ifdef DEBUG_INIT_SPELL_FINDER
            printf("right max is now %d\n", max_count_r);
#endif
          }
        }
      }
    }
  }

  /* ensure the comment above the definition of spell_finder_* is correct */
  if (max_count_l != MAX_SPELL_FINDER_L) {
    printf("init_spell_finder(): max_count_l == %d not %d\n",
           max_count_l, MAX_SPELL_FINDER_L);
    exit(1);
  }
  if (max_count_r != MAX_SPELL_FINDER_R) {
    printf("init_spell_finder(): max_count_r == %d not %d\n",
           max_count_r, MAX_SPELL_FINDER_R);
    exit(1);
  }
}

/* Bitmap of spells indicating that if the spell can be invoked there
 * is no point even considering invoking another spell on that hand
 * (eg. if you can use the finger of death, no point even considering
 * any other spell (which in that case would only be a missile)).
 *
 * We take advantage of that fact that there are no cases where the
 * gestures that make up one spell also form a second and third spell
 * where the first spell trumps the second but not the third.  If this
 * was not the case, we'd need an array of bitmaps instead of just the
 * one bitmap.
 */
static unsigned long long spell_trumps;

#define spell_bit(spell) ((unsigned long long)1 << (spell))

static void init_spell_trumps(void) {
  spell_trumps =
      spell_bit(SPL_FINGER_OF_DEATH) |      // trumps SPL_MISSILE
      spell_bit(SPL_COUNTER_SPELL) |        // trumps SPL_SHIELD
      spell_bit(SPL_PROTECTION_FROM_EVIL) | // trumps SPL_SHIELD
      spell_bit(SPL_SUMMON_GIANT) |         // SPL_SUMMON_OGRE, TROLL, GOBLIN
      spell_bit(SPL_SUMMON_OGRE) |          // SPL_SUMMON_TROLL, GOBLIN
      spell_bit(SPL_SUMMON_TROLL);          // SPL_SUMMON_GOBLIN
}

static void init_spell_order(void) {
  int i;

  for (i = 0; i < SPL_FINAL_MARKER; i++) {
    spell_order[spell_order_inverse[i]] = i;
  }
}

void get_spellpair_list(GestureList gl, SpellPair *sp) {
  signed char *start_gl_l = spell_finder_l[gl & GST_MASK_2];
  signed char *start_gl_r = spell_finder_r[gl & GST_MASK_2];
  signed char *i, *j;
  int two_handed = 0;

#ifdef DEBUG_GET_SPELLPAIR_LIST
  for (i = start_gl_l; *i != -1; i++) {
    if ((gl & spell_match_left_mask[*i]) == spell_match_left[*i]) {
      printf("LH matches %s\n", spell_name[spell_match_left_type[*i]]);
    }
  }

  for (i = start_gl_r; *i != -1; i++) {
    if ((gl & spell_match_right_mask[*i]) == spell_match_right[*i]) {
      printf("RH matches %s\n", spell_name[spell_match_right_type[*i]]);
    }
  }
#endif

  /* no spells on either hand? */
  if (*start_gl_l == -1 && *start_gl_r == -1) {
    *sp = 0;
    return;
  }

  /* spells on LH only? */
  if (*start_gl_r == -1) {
    for (i = start_gl_l; *i != -1; i++) {
      if ((gl & spell_match_left_mask[*i]) == spell_match_left[*i]) {
        unsigned char spell = spell_match_left_type[*i];
        *sp++ = make_spell_pair(spell, 0);
#ifdef DEBUG_GET_SPELL_LIST
        printf("LH matches %s\n", spell_name[spell]);
#endif
        if (spell_trumps & spell_bit(spell)) {
          break;
        }
      }
    }

    *sp = 0;
    return;
  }

  /* spells on RH only? */
  if (*start_gl_l == -1) {
    for (i = start_gl_r; *i != -1; i++) {
      if ((gl & spell_match_right_mask[*i]) == spell_match_right[*i]) {
        unsigned char spell = spell_match_right_type[*i];
        *sp++ = make_spell_pair(0, spell);
#ifdef DEBUG_GET_SPELL_LIST
        printf("RH matches %s\n", spell_name[spell]);
#endif
        if (spell_trumps & spell_bit(spell)) {
          break;
        }
      }
    }

    *sp = 0;
    return;
  }

#ifdef DEBUG_GET_SPELL_LIST
  printf("Both hands can match\n");
#endif

  /* Go through each combination of spells that can be made with the
   * left and right hands at the same time.
   */
  /* possible spells on both hands */
  int left_trumped = 0;
  for (i = start_gl_l; *i != -1 && !left_trumped; i++) {

    for (j = start_gl_r; *j != -1; j++) {

      /* do the spells conflict? */
      if ((spell_match_left_mask[*i] & spell_match_right_mask[*j]) == 0) {

        /* the spells don't conflict; do they match? */
        if (((gl & spell_match_left_mask[*i]) == spell_match_left[*i]) &&
            ((gl & spell_match_right_mask[*j]) == spell_match_right[*j])) {
          unsigned char spell_left = spell_match_left_type[*i];
          unsigned char spell_right = spell_match_right_type[*j];
#ifdef DEBUG_GET_SPELL_LIST
          printf("Two spells match: %s + %s\n",
                 spell_name[spell_left],
                 spell_name[spell_right]);
#endif
          *sp++ = make_spell_pair(spell_left, spell_right);
          two_handed = 1;
          if (spell_trumps & spell_bit(spell_left)) {
            left_trumped = 1;
          }
          if (spell_trumps & spell_bit(spell_right)) {
            break;
          }
        }
      }
    }
  }

  /* if two spells can be done simultaneously, there are no spells
   * that can be done separately with the same gestures
   */
  if (two_handed) {
    *sp = 0;
    return;
  }

  /* If none can be made, two_handed won't be set so we start looking
   * for spells that can be done with either hand separately.
   */
#ifdef DEBUG_GET_SPELL_LIST
  printf("No simultaneous two-handed match\n");
#endif
  for (i = start_gl_l; *i != -1; i++) {
    if ((gl & spell_match_left_mask[*i]) == spell_match_left[*i]) {
      unsigned char spell = spell_match_left_type[*i];
#ifdef DEBUG_GET_SPELL_LIST
      printf("LH matches: %s\n", spell_name[spell]);
#endif
      *sp++ = make_spell_pair(spell, 0);
      if (spell_trumps & spell_bit(spell)) {
        break;
      }
    }
  }
  for (i = start_gl_r; *i != -1; i++) {
    if ((gl & spell_match_right_mask[*i]) == spell_match_right[*i]) {
      unsigned char spell = spell_match_right_type[*i];
#ifdef DEBUG_GET_SPELL_LIST
      printf("RH matches: %s\n", spell_name[spell]);
#endif
      *sp++ = make_spell_pair(0, spell);
      if (spell_trumps & spell_bit(spell)) {
        break;
      }
    }
  }

  *sp = 0;
}

void init_spells(void) {
  init_spell_match();
  init_spell_finder();
  init_spell_trumps();
  init_spell_order();
}
