/* A Move is composed of the GestureList of the wizard (who) plus the
 * spell(s) that have been invoked.  If the wizard cast a paralysis
 * spell in the previous turn, paralysis_hand is 1 (for left) or 2
 * (for right) (we won't paralyse more than one opponent at a time
 * since that would use both of our hands), paralysis_who is who we
 * are paralysing.
 */
typedef struct Move {
  GestureList   gl;
  SpellPair     sp;
  char          paralysis_hand;
  unsigned char paralysis_who;
  unsigned char who;
  int           score;
} Move;

void find_move_id(WizardState *ws, int num_ws,
                  int timeout, Move *best_move_out);
void show_move(Move *move);
void init_moves(void);
void cleanup_moves(void);
