#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>

typedef struct Message {
  int          header;
  unsigned int length;
  int          cmd;
  char         data[0];
} Message;

int connect_to_server(char *host);
int read_bytes(int fd, void *data, int data_len);
void write_bytes(int fd, const void *data, int data_len);
Message *msg_recv(int fd);
void msg_send(int fd, int cmd, void *data, int data_len);

#define get_int(data) (ntohl(*(int *)(data)))
#define put_int(data, value) (*(int *)(data) = htonl(value))
#define next_int(data) (data += sizeof(int))

