#define _GNU_SOURCE
#include "TetrinetServer.h"
#include <iostream>

using namespace std;

void BlockStatus::printBlock()
{
	for(int y=0;y<4;y++)
	{
		for(int x=0;x<4;x++)
		{
			if(blockmap[type][y*4+x])
				cout << "*";
			else
				cout << ".";
		}
		cout<<endl;
	}
}

TetrinetServer::TetrinetServer(string host, int port, string name, string team, string channel)
{
	isConnected=false;
	gameOn=false;
	cout << host << ":" << port << "\t" << name << ":" << team << ":" << channel << endl;
	int j=connectToServer((char *)host.c_str(), port, (char *)name.c_str(), (char *)team.c_str(), (char *)channel.c_str());
	if(j==0)
		isConnected=true;
	else
		cout << "Server error: " << j;

	// create the mutex
	pthread_mutexattr_t mattr;
	pthread_mutexattr_init(&mattr);
	pthread_mutexattr_settype(&mattr, PTHREAD_MUTEX_RECURSIVE);
	
	//pthread_mutexattr_settype(&mattr, PTHREAD_MUTEX_RECURSIVE);
	pthread_mutex_init(&myMutex, &mattr);
}

TetrinetServer::~TetrinetServer()
{
	// destroy the mutex
	pthread_mutex_destroy(&myMutex);
	FreeGameData(gdata);
}

TetrinetField TetrinetServer::getField(int player)
{
	MutexLocker fuckyoucplusplus(&myMutex);
	if(player== -1)
		player=ownPlayer;
	if(player== -1)
		player=ownPlayer=GetOwnPlayerNumber(gdata);
	char *ifield=GetField(player);
	fieldValid[player]=true;
	return TetrinetField(ifield);
}

BlockStatus TetrinetServer::getNextBlock()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	BlockStatus b;
	GetNextBlock(&b.type);
	b.y=0;
	b.x=TC_FIELD_WIDTH/2;
	return b;
}

void TetrinetServer::pollEvents()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int fromPlayer;
	int toPlayer;
	int special;
	int j=GetSpecialNotification(&fromPlayer, &toPlayer, &special);
	if(j==0)
	{

		//cout << "************* " << endl;
		//cout << "Special: " << special << endl;
		//cout << "************* " << endl;

		switch(special)
		{
			// update line offset tables
			case TC_SPECIAL_ADD_LINE:
				// add to all?
				if(toPlayer== -1)
				{
					cout << "Line added to all" << endl;
					for(int x=0;x<6;x++)
						if(x!=fromPlayer)
							linesAdded[x]++;
				}
				else
				{
					cout << "Line added to player " << toPlayer << endl;
					linesAdded[toPlayer]++;
				}
				break;
			case TC_SPECIAL_ADDALL1:
				cout << "1 line added to all" << endl;
				for(int x=0;x<6;x++)
					if(x!=fromPlayer)
						linesAdded[x]++;
				break;
			case TC_SPECIAL_ADDALL2:
				cout << "2 lines added to all" << endl;
				for(int x=0;x<6;x++)
					if(x!=fromPlayer)
						linesAdded[x]+=2;
				break;
			case TC_SPECIAL_ADDALL4:
				cout << "4 lines added to all" << endl;
				for(int x=0;x<6;x++)
					if(x!=fromPlayer)
						linesAdded[x]+=4;
				break;
			case TC_SPECIAL_CLEAR_LINE:
				linesAdded[toPlayer]--;
				break;
				// check for field invalidation
			case TC_SPECIAL_BLOCK_GRAVITY:
			case TC_SPECIAL_NUKE:
			case TC_SPECIAL_BLOCK_BOMB:
			case TC_SPECIAL_BLOCK_QUAKE:
			case TC_SPECIAL_CLEAR_RANDOM:
				cout << "Invalidating field for player " << toPlayer << endl;
				fieldValid[toPlayer]=false;
				break;
			case TC_SPECIAL_SWITCH_FIELDS:
				cout << "Invalidating field for player " << toPlayer << endl;
				fieldValid[toPlayer]=false;
				fieldValid[fromPlayer]=false;
				break;
		}

		// append this event to the event queue, so that
		// we can deal with special use elsewhere
	}
}

string TetrinetServer::getMessage(int *fromPlayer)
{
	MutexLocker fuckyoucplusplus(&myMutex);
	char *t;
	int j=GetMessage(fromPlayer, &t);
	string z;
	if(j==0)
	{
		z=t;
		free(t);
		return z;
	}
	else
	{
		*fromPlayer= -1;
		return "";
	}
}

BlockStatus TetrinetServer::getCurrentBlock(int player)
{
	MutexLocker fuckyoucplusplus(&myMutex);
	pollEvents();
	if(player== -1)
		player=ownPlayer;
	if(player== -1)
		player=ownPlayer=GetOwnPlayerNumber(gdata);
	BlockStatus b;
	int j=GetCurrentBlock(&b.type, &b.x, &b.y);
	if(j!=0)
		b.type= -1;
	if(b.type==0)
		b.y= -1;
	if(b.type<0)
		gameOn=false;
	return b;
}

bool TetrinetServer::moveLeft()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_MOVE_LEFT);
	return(j==0);
}

bool TetrinetServer::moveRight()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_MOVE_RIGHT);
	return(j==0);
}

bool TetrinetServer::moveDown()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_MOVE_DOWN);
	return(j==0);
}

bool TetrinetServer::rotateClockwise()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_ROTATE_CLOCKWISE);
	return(j==0);
}

bool TetrinetServer::rotateAnticlockwise()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_ROTATE_ANTICLOCKWISE);
	return(j==0);
}

bool TetrinetServer::dropBlock()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	int j=MoveBlock(TC_MOVE_DROP);
	return(j==0);
}

bool TetrinetServer::startGame()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	ownPlayer = -1;
	for(int x=0;x<6;x++)
	{
		linesAdded[x]=0;
		fieldValid[x]=false;
	}
	int j=Start(&gdata);
	if(j==0)
		gameOn=true;
	return gameOn;
}

int TetrinetServer::getMaxSpecials()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	return GetMaxSpecials(gdata);
}

vector<char> TetrinetServer::getSpecials()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	// FIXME: THIS IS SO INCREDIBLY BAD, IT IS WITHOUT COMPARISON, IT IS JUST SO SO SO BAD
	char ispec[1000];
	GetSpecials(ispec);
	vector<char> ospec;
	ospec.clear();
	while(ispec[ospec.size()]!=0)
		ospec.push_back(ispec[ospec.size()]);
	return ospec;
}

int TetrinetServer::getNumPlayers()
{
	return GetNumPlayers(gdata)+1;
}

void TetrinetServer::useSpecial(int player)
{
	MutexLocker fuckyoucplusplus(&myMutex);
	UseSpecial(player);
}

void TetrinetServer::discardSpecial()
{
	MutexLocker fuckyoucplusplus(&myMutex);
	DiscardSpecial();
}

bool TetrinetServer::connected()
{
	return isConnected;
}

void TetrinetServer::sendMessage(string message, int player)
{
	MutexLocker fuckyoucplusplus(&myMutex);
	SendMessage(player, (char *)message.c_str());
}

int TetrinetServer::getOwnPlayer()
{
	if(ownPlayer>=0)
	{
		return ownPlayer;
	}
	else
	{
		ownPlayer=GetOwnPlayerNumber(gdata);
		return ownPlayer;
	}
}
