#include <stdarg.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

static int log_level = 2;
static int pid = 0;

void tbt_log(int level, char *fmt, ...)
{
	va_list ap;

	if (level>log_level)
	{
		va_start(ap, fmt);
		printf("[%i] ", pid);
		vprintf(fmt, ap);
	}
}

void tbt_log_plain(int level, char *fmt, ...)
{
	va_list ap;

	if (level>log_level)
	{
		va_start(ap, fmt);
		vprintf(fmt, ap);
	}
}

void tbt_setpid()
{
	pid = (int) getpid();
}

void set_log_level(int level)
{
	log_level = level;
}
