/*
 *  Many parts taken from GTetrinet
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)
 *  Copyright (C) 2003 Jeremy Kerr (jeremy@redfishsoftware.com.au)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <netinet/in.h>

#include <sys/types.h>
#include <sys/socket.h>


#include <stdlib.h>

#define _GNU_SOURCE
#include <stdio.h>

#include <string.h>
#include <unistd.h>
#include <assert.h>
#include <sys/time.h>
#include <netdb.h>

#include "client.h"
#include "comm_client.h"
#include "tetris.h"

#define PORT 31457
// #define NICK "jk-bot"

static void process_response(char *buf, int len);

static void sendfield(int reset, struct game *newgame);

struct timeval last_move_time;

int main(int argc, char **argv)
{
	int sd;
	struct sockaddr_in addr;
	struct in_addr server_address;
	/* todo: max message size */
	unsigned char buf[4096];
	struct timeval tv, curtime; /* , movetime; */
	fd_set fdset;
	struct hostent *tetrinet_server_host;

	int serverSocket, clientSocket;
	struct sockaddr_in clientAcceptAddress;
	int tmp_int;

	/* Players with null name don't exist */
	for (tmp_int=0; tmp_int<6; tmp_int++)
	{
		strcpy(game.players[tmp_int].name, "");
	}

	serverSocket = createServerSocket(9467);
	tmp_int = sizeof(clientAcceptAddress);
	printf("Waiting for client connection\n");
	if ( (clientSocket = accept(serverSocket, 
															(struct sockaddr *)&clientAcceptAddress, 
															&tmp_int)) < 0)
	{
		printf("client accept failed\n");
	}
	else
	{
		printf("Got client connection\n");
		processClientMessage(clientSocket, &SendField);
	}

	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		return EXIT_FAILURE;
	}


	server_address.s_addr = 0;
	if (argc>1)
	{
		tetrinet_server_host = gethostbyname(argv[1]);
		if (tetrinet_server_host)
		{
			memcpy(&server_address, tetrinet_server_host->h_addr_list[0],
						 tetrinet_server_host->h_length);
		}
	}


	memset ((char *)&addr, 0, sizeof(addr));
        addr.sin_family = AF_INET;
        addr.sin_port   = htons(PORT);
        memcpy(&(addr.sin_addr), &server_address, sizeof(server_address));

	if (connect(sd, (struct sockaddr *)&addr, sizeof(addr))) {
		perror("connect");
		close(sd);
		return EXIT_FAILURE;
	}

 	client_init(sd, getUsername());

	while (1) {
		int len, i, ret, array_i;
		unsigned char *bufptr;
		

		if (game.gameon && ClientState==CC_CLIENT_READY)
		{
			struct TC_GameData *gd;
			int num_players = 0, i;

			/* Set player state */
			tetris_set_player_state(0);

			/* Setup block frequencies */
			tetris_set_block_frequencies(game.piecefrequencyarray);
			tetris_set_block_special_frequencies(game.specialfrequencyarray);
			tetris_set_num_specials(game.specialcapacity);


			/* Create a pending block */
			tetris_make_pending_block();


			for (i=0; i<6; i++)
			{
				if (strcmp(game.players[i].name, "")!=0) num_players++;
			}
			printf("Found %i players\n", num_players);

			gd = malloc(sizeof(struct TC_GameData) 
									+ num_players*sizeof(struct TC_PlayerData));
			gd->MaxNumSpecials = game.specialcapacity;
			gd->NumberOfPlayers = num_players;
			gd->PlayerNumber = game.playernum-1;

			printf("Own player number is %i\n", gd->PlayerNumber);

			for (i=0, array_i=0; i<num_players; i++)
			{
				if (strcmp(game.players[i].name, "")!=0)
				{
					gd->Players[array_i].PlayerNumber = i;
					asprintf(&gd->Players[array_i].PlayerName, "%s", 
									 game.players[i].name);
					asprintf(&gd->Players[array_i].TeamName, "%s", 
									 game.players[i].team);
					printf("--- Added player %s (%i), index %i\n", 
								 gd->Players[array_i].PlayerName,
								 array_i, 
								 gd->Players[array_i].PlayerNumber);
					array_i++;
				}
			}

			startClient(clientSocket, gd);
			ClientState = CC_CLIENT_PLAYING;
			free(gd);

		}

		gettimeofday(&curtime, NULL);

		if (game.gameon)
		{
			/* Copy field */
			memcpy(&GameState, &game, sizeof(struct game));

			/* Calculate timeout 
				 We want to drop the block no sooner than
				 one second since the last drop */
			curtime.tv_sec -= 1;
			printf("curr time: %i, %i\nlast_time: %i %i\n",
						 curtime.tv_sec, curtime.tv_usec,
						 last_move_time.tv_sec, last_move_time.tv_usec);
			if (curtime.tv_sec>last_move_time.tv_sec
					|| (curtime.tv_sec==last_move_time.tv_sec
							&& curtime.tv_usec>=last_move_time.tv_usec))
			{
				/* More than one second has elapsed */
				tv.tv_sec = 0;
				tv.tv_usec = 0;
			}
			else
			{
				tv.tv_sec = 0;
				if (last_move_time.tv_sec>curtime.tv_sec)
				{
					tv.tv_usec = 1000000 - curtime.tv_usec + last_move_time.tv_usec;
				}
				else
				{
					tv.tv_usec = last_move_time.tv_usec - curtime.tv_usec;
				}
			}
		}

		FD_ZERO(&fdset);
		FD_SET(sd, &fdset);
		FD_SET(clientSocket, &fdset);

		
		printf("timeout in %d sec %d\n", (int)tv.tv_sec, (int)tv.tv_usec);

		ret = select(sd > clientSocket ? sd+1 : clientSocket+1, 
								 &fdset, NULL, NULL, 
								 (game.gameon && !tetris_player_is_dead()) ? &tv : NULL);


		if (ret==0 && !tetris_player_is_dead())
		{
			/* Timeout - so should move block */
			if (get_current_block()<0)
			{
				printf("new block\n");
				if (tetris_makeblock(tetris_pending_block(), 
														 tetris_pending_block_orient(),
														 GameState.players[GameState.playernum-1].field)
						== 1)
				{
					/* player has died */
					char *msg;
					printf("** Player is dead\n");
					tetris_set_player_state(1);
					tetris_create_dead_field(
						GameState.players[GameState.playernum-1].field);
					sendfield(0, &GameState);
					asprintf(&msg, "playerlost %i", GameState.playernum);
					client_send(msg, strlen(msg));
					free(msg);
					SendField = 1;
				}
				else
				{
					tetris_make_pending_block();
				}
			}
			else
			{
				printf("drop block\n");
				if (tetris_blockdown(GameState.players[GameState.playernum-1].field)==-1)
				{
					if (tetris_solidify(GameState.players[GameState.playernum-1].field)
							== 0)
					{
						int lines_cleared, i, j;
						char specials[200];
						char *spc;
						lines_cleared = tetris_removelines(
							specials, 
							GameState.players[GameState.playernum-1].field);
						tetrinet_addsbtofield(
							lines_cleared, 
							GameState.players[GameState.playernum-1].field);
						i=0;
						while (specials[i]!=0)
						{
							for (j=0; j<lines_cleared; j++)
								tetris_add_special(specials[i]);
							i++;
						}
						/* send extra lines to other people */
						switch (lines_cleared)
						{
						case 4:
							spc = "cs4";
							break;
						case 3:
							spc = "cs2";
							break;
						case 2:
							spc = "cs1";
							break;
						default:
							spc = NULL;
						}
						if (spc) send_special(0, spc, GameState.playernum);
					}
					else
					{
						/* player is dead */
						printf("** Player is dead\n");
						tetris_set_player_state(1);
						tetris_create_dead_field(
							GameState.players[GameState.playernum-1].field);
						sendfield(0, &GameState);
					}

					SendField = 1;
				}
			}

			/* Reset last time move */
			gettimeofday(&last_move_time, NULL);
			
		}

		if (FD_ISSET(sd, &fdset)) {
			len = client_receive(buf, 1024);
		
			bufptr = buf;
			for (i = 0; i < len; i++) {
				if (*(buf + i) == 0xff) {
					process_response(bufptr, i - (bufptr - buf));
					bufptr = buf + i + 1;
				}
			}
		}

		if (FD_ISSET(clientSocket, &fdset))
		{
			printf("processing message from client\n");
			if (processClientMessage(clientSocket, &SendField))
			{
				/* Timer should be reset */
				gettimeofday(&last_move_time, NULL);
			}
		}

		if (SendField)
		{
			sendfield(0, &GameState);
			SendField = 0;
		}

	}
	
	/* parse args */

	return 0;
}

static inline int safe_strcmp(const char *buf, const char *str,
                              unsigned int bufl)
{
	unsigned int strl = strlen(str);
	return !strncmp(buf, str, strl < bufl ? strl : bufl);
}

static char blocks[] = "012345acnrsbgqo";

static void print_field(struct player *p)
{
	int x, y;

	printf("field %s --\n", p->name);
	for (y = 0; y < FIELD_HEIGHT; y++) {
		for (x = 0; x < FIELD_WIDTH; x++) {
			int i = p->field[y][x];
			printf("%c", i < strlen(blocks) ? blocks[i] : 'x');
		}
		printf("\n");
	}
}

/**
 * modified from gtetrinet/tetrinet.c
 */
void sendfield(int reset, struct game *newgame)
{
  int x, y, i, d = 0; /* d is the number of differences */
  char buf[1024], *p;
  char *field = (char *)(newgame->players[game.playernum-1].field);

  char diff_buf[15][(FIELD_WIDTH + 1) * FIELD_HEIGHT * 2] = {{0}};

  int row_count[15] = {1,1,1,1,1, 1,1,1,1,1, 1,1,1,1,1};

  printf("sending field %i:\n", game.playernum);
	for (y = 0; y < FIELD_HEIGHT; y++) {
		for (x = 0; x < FIELD_WIDTH; x++) {
			int i = *(field + y * FIELD_WIDTH + x);
			printf("%c", i < strlen(blocks) ? blocks[i] : 'x');
		}
		printf("\n");
	}
  
  sprintf(buf, "f %d ", game.playernum);

  if(!reset) {
    /* Find out which blocks changed, how, and how many */
    for (y = 0; y < FIELD_HEIGHT; y ++) {
      for (x = 0; x < FIELD_WIDTH; x ++) {

	const char block = *(field + y * FIELD_WIDTH + x);

        if ((block < 0) || (block >= 15))
        {
          fprintf(stderr, "sendfield shouldn't reach here, block=%d\n", block);
          continue;
        }
        
	if (block != game.players[game.playernum-1].field[y][x]) {
	  diff_buf[(int)(block)][row_count[(int)block]++] = x + '3';
	  diff_buf[(int)(block)][row_count[(int)block]++] = y + '3';
	  d += 2;
	}
      }
    }
    if (d == 0) return; /* no differences */

    for (i = 0; i < 15; ++i)
      if (row_count[i] > 1)
        ++d; /* add an extra value for the '!'+i at the start */
  }
  
  if (reset || d >= (FIELD_HEIGHT*FIELD_WIDTH)) {
    /* sending entire field is more efficient */
    p = buf + 4;
    for (y = 0; y < FIELD_HEIGHT; y ++)
      for (x = 0; x < FIELD_WIDTH; x ++)
	*(p++) = blocks[(int)(game.players[game.playernum-1].field[y][x])];
    *p = 0;
  }
  else { /* so now we need to create the buffer strings */
    for(i = 0; i < 15; ++i) {
      if(row_count[i] > 1) {
	diff_buf[i][0] = '!' + i;
	strcat(buf, diff_buf[i]);
      }
    }
  }

  client_send(buf, strlen(buf));
  /* update the one in our memory */
  memcpy(game.players[game.playernum-1].field,
  	 newgame->players[game.playernum-1].field,
         sizeof(char) * FIELD_WIDTH * FIELD_HEIGHT);
}

char translateblock(char c)
{
    int i;
    for (i = 0; blocks[i]; i ++)
        if (c == blocks[i]) return i;
    return 0;
}

static void process_response(char *buf, int len)
{
	char *tmp, *op, *delim = " ";

	*(buf + len) = 0;

/* 	printf("len: %d, string: %s\n", len, buf); */
	op = strtok(buf, delim);

	printf("op: %s\n", op);

	if (!op)
		return;

	if (safe_strcmp(op, "playernum", len)) {
		char *return_message;
		tmp = strtok(NULL, delim);
		assert(tmp);
		game.playernum = atoi(tmp);
		printf("player num: %d\n", game.playernum);
		asprintf(&return_message, "team %i ", game.playernum);
//		return_message[6] = 0xFF;
		client_send(return_message, 7);
		
	} else if (safe_strcmp(buf, "winlist", len)) {
		printf("winlist\n");

	} else if (safe_strcmp(buf, "playerjoin", len)) {
		int pn;
		
		tmp = strtok(NULL, delim);
		assert(tmp);

		pn = atoi(tmp);
		assert(pn >= 0 && pn < 6);

		tmp = strtok(NULL, delim);
		assert(tmp);

		strncpy(game.players[pn-1].name, tmp, NAMELEN - 1);

	} else if (safe_strcmp(buf, "team", len)) {
		int pn;
		
		tmp = strtok(NULL, delim);
		assert(tmp);

		pn = atoi(tmp);
		printf("pn %i, gpn %i\n", pn, game.playernum);
//		assert(pn > 0 && pn != game.playernum && pn < 7);

		tmp = strtok(NULL, delim);

		if (tmp) {
			strncpy(game.players[pn-1].team, tmp, NAMELEN - 1);
		} else {
			game.players[pn-1].team[0] = '\0';
		}

	} else if (safe_strcmp(buf, "newgame", len)) {
		int i;

		assert(tmp = strtok(NULL, delim));
		/* stack height ? */

		assert(tmp = strtok(NULL, delim));
		game.initiallevel = atoi(tmp);

		assert(tmp = strtok(NULL, delim));
		game.linesperlevel = atoi(tmp);
		
		assert(tmp = strtok(NULL, delim));
		game.levelinc = atoi(tmp);
		
		assert(tmp = strtok(NULL, delim));
		game.speciallines = atoi(tmp);

		assert(tmp = strtok(NULL, delim));
		game.specialcount = atoi(tmp);

		assert(tmp = strtok(NULL, delim));
		game.specialcapacity = atoi(tmp);

		assert(tmp = strtok(NULL, delim));
		while (*tmp) {
			i = *tmp - '1';
			if (i >= 0 && i < 7)
				game.piecefrequencyarray[i]++;
			tmp++;
		}
		for (i=1; i<7; i++)
		{
			game.piecefrequencyarray[i] += game.piecefrequencyarray[i-1];
		}
		if (game.piecefrequencyarray[6]<100)
			game.piecefrequencyarray[6] = 100;


		assert(tmp = strtok(NULL, delim));
		while (*tmp) {
			i = *tmp - '1';
			if (i >= 0 && i < 9)
				game.specialfrequencyarray[i]++;
			tmp++;
		}
		for (i=1; i<9; i++)
		{
			game.specialfrequencyarray[i] += game.specialfrequencyarray[i-1];
		}
		if (game.specialfrequencyarray[8]<100)
			game.specialfrequencyarray[8] = 100;


		assert(tmp = strtok(NULL, delim));
		game.levelavg = atoi(tmp);

		assert(tmp = strtok(NULL, delim));
		game.oldmode = atoi(tmp);

		for (i = 0; i < 6; i++) {
			memset(&game.players[i].field, 0,
			       FIELD_HEIGHT * FIELD_WIDTH);
			game.players[i].level = game.initiallevel;
		}

		sendfield(1, &game);

		game.gameon = 1;

		gettimeofday(&last_move_time, NULL);

	} else if (safe_strcmp(buf, "f", len)) {
		int pn;
		
		assert(tmp = strtok(NULL, delim));
		pn = atoi(tmp) - 1;

		assert(tmp = strtok(NULL, delim));

		if (*tmp >= '0') {
			char *p = (char *)game.players[pn].field;
			for (; *tmp; tmp ++, p ++)
                    		*p = translateblock(*tmp);
		} else {
			char block = 0;
			int x, y;
			while (*tmp) {
				if (*tmp < '0' && *tmp >= '!') {
					block = *tmp - '!';
				} else {
					x = *tmp - '3';
					y = *(++tmp) - '3';
					game.players[pn].field[y][x] = block;
				}
				tmp++;
			}
		}
		print_field(&game.players[pn]);
	
	} else if (safe_strcmp(buf, "sb", len))
	{
		/* incoming special block */
		int toplayer, fromplayer;
		char *specialtype;

		tmp = strtok(NULL, delim);
		assert(tmp);
		toplayer = atoi(tmp);

		tmp = strtok(NULL, delim);
		assert(tmp);
		specialtype = strdup(tmp);
		
		tmp = strtok(NULL, delim);
		assert(tmp);
		fromplayer = atoi(tmp);

		printf("Received special %s from player %i (to %i)\n",
					 specialtype, fromplayer, toplayer);

		if (toplayer==GameState.playernum || toplayer==0)
		{
			printf("special was directed to us\n");
			if (toplayer==0) toplayer = GameState.playernum;
			SendField = 1;
			if (strcmp(specialtype, "a")==0 || strcmp(specialtype, "cs1")==0)
			{
				tetris_addlines(1, GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "cs2")==0)
			{
				tetris_addlines(2, GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "cs4")==0)
			{
				tetris_addlines(4, GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "c")==0)
			{
				tetris_clearline(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "n")==0)
			{
				memset(GameState.players[toplayer-1].field, 0, 
							 FIELD_WIDTH*FIELD_HEIGHT);
			}
			else if (strcmp(specialtype, "r")==0)
			{
				tetris_clear_random(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "b")==0)
			{
				tetris_clear_specials(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "g")==0)
			{
				tetris_block_gravity(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "q")==0)
			{
				tetris_block_quake(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "o")==0)
			{
				tetris_block_bomb(GameState.players[toplayer-1].field);
			}
			else if (strcmp(specialtype, "s")==0)
			{
				tetris_switch_fields(GameState.players[toplayer-1].field,
														 GameState.players[fromplayer-1].field);
			}
			else
			{
				printf("Unknown special %i\n", specialtype);
			}
			tetris_removelines(NULL, GameState.players[GameState.playernum-1].field);
		}


	} else if (safe_strcmp(buf, "playerlost", len))
	{
		int player;

		tmp = strtok(NULL, delim);
		assert(tmp);
		player = atoi(tmp);

		printf("Player %i has died\n", player);

	} else if (safe_strcmp(buf, "endgame", len))
	{
		printf("Game has ended\n");
		game.gameon = 0;
		ClientState = 0;

	} else if (safe_strcmp(buf, "playerwon", len))
	{
		int player;
						 
		tmp = strtok(NULL, delim);
		assert(tmp);
		player = atoi(tmp);

		printf("Player %i won\n", player);

	} else if (safe_strcmp(buf, "pline", len))
	{
		int from_player;
		tmp = strtok(NULL, delim);
		assert(tmp);
		from_player = atoi(tmp);

		tmp = strtok(NULL, "");
		assert(tmp);

		printf("Message from player %i\n  %s\n", from_player, tmp);


	} else {
		printf("unknown opcode %s\n", op);
		printf("Message was - len: %d, string: %s\n", len, buf);

	}
}
