/*
   Copyright (C) 2003 Christopher Yeoh <cyeoh@samba.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA. 
*/
#include <unistd.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <stdio.h>

int writeNumBytes(int Socket, const void *Buffer, int NumBytes)
{
	int res, index = 0;

	while (index<NumBytes)
	{
		res = write(Socket, Buffer+index, NumBytes-index);
		if (res<0) return -1;
		else index += res;
	}
	return index;
}

int readNumBytes(int Socket, void *Buffer, int NumBytes)
{
	int res, count = 0;
	while (count<NumBytes)
	{
		res = read(Socket, Buffer+count, NumBytes-count);
		if (res<0) 
		{
			printf("read error\n");
			return -1;
		}
		else count += res;
	}
	return count;
}

int writeString(int Socket, const char *String)
{
	int length = strlen(String)+1;
	int hlength = htonl(length);
	if (writeNumBytes(Socket, &hlength, sizeof(hlength))<0)
		return -1;
	return writeNumBytes(Socket, String, length);
}

char *readString(int Socket)
{
	char *new_string;
	int length;
	if (readNumBytes(Socket, &length, sizeof(length))<0)
	{
		return NULL;
	}
	else
	{
		length = ntohl(length);
		new_string = malloc(length);
		if (!new_string) 
		{
			printf("Malloc for %i failed\n", length);
			return NULL;
		}
		else
		{
			if (readNumBytes(Socket, new_string, length)<0)
			{
				printf("String read failed\n");
				return NULL;
			}
			else
			{
/* 				printf("Read string length %i\n", length); */
				return new_string;
			}
		}
	}
}

int writeInt32(int Socket, int Value)
{
	Value = htonl(Value);
	return writeNumBytes(Socket, &Value, sizeof(Value));
}

int readInt32(int Socket)
{
	int value;
	readNumBytes(Socket, &value, sizeof(value));
	value = ntohl(value);
	return value;
}
