#define _GNU_SOURCE
#include <stdarg.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

static int log_level = 2;
static int pid = 0;
static FILE *OUTPUT_FILE = NULL;

void tbt_log(int level, char *fmt, ...)
{
	va_list ap;

	if (level>log_level)
	{
		va_start(ap, fmt);
		if (OUTPUT_FILE)
		{
			fprintf(OUTPUT_FILE, "[%i] ", pid);
			vfprintf(OUTPUT_FILE, fmt, ap);
			fflush(OUTPUT_FILE);
		}
		else
		{
			printf("[%i] ", pid);
			vprintf(fmt, ap);
		}
	}
}

void tbt_log_plain(int level, char *fmt, ...)
{
	va_list ap;

	if (level>log_level)
	{
		va_start(ap, fmt);
		vprintf(fmt, ap);
	}
}

void tbt_setpid(void)
{
	pid = (int) getpid();
}

void set_log_level(int level)
{
	log_level = level;
}

void tbt_set_log_file(char *filename_suffix)
{
	char *filename, *tmp_dir;
	tmp_dir = getenv("TMPDIR");
	if (tmp_dir==NULL) tmp_dir = "/tmp";

	asprintf(&filename, "%s/tetribot.%s", tmp_dir, filename_suffix);

	OUTPUT_FILE = fopen(filename, "w");
	if (OUTPUT_FILE==NULL)
	{
		printf("Warning: failed to open %s\n", filename);
	}
	free(filename);
}
