#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "getMove.h"

struct PlayerData g_player_data[MAX_NUM_PLAYERS];
struct PlayerData *g_player_order[MAX_NUM_PLAYERS];
struct PlayerData *g_my_player_data;

int g_num_players;
int g_num_alive_players;

char SpecialToChar(int special)
{
  switch(special)
  {
    case TC_SPECIAL_CLEAR_LINE:
      return 'c';
      break;
    case TC_SPECIAL_BLOCK_GRAVITY:
      return 'g';
      break;
    case TC_SPECIAL_NUKE:
      return 'n';
      break;
    case TC_SPECIAL_SWITCH_FIELDS:
      return 's';
      break;
    case TC_SPECIAL_ADD_LINE:
      return 'a';
      break;
    case TC_SPECIAL_BLOCK_BOMB:
      return 'o';
      break;
    case TC_SPECIAL_CLEAR_RANDOM:
      return 'r';
      break;
    case TC_SPECIAL_CLEAR_SPECIALS:
      return 'b';
      break;
    case TC_SPECIAL_BLOCK_QUAKE:
      return 'q';
      break;
  }
  return 'u';
}

void PrintPlayersSpecials(void)
{
  int i, j;

  for(i = 0; i < g_num_players; i++)
  {
    if(g_player_data[i].m_player_active);
    printf("%s specials: ", g_player_data[i].m_player_name);
    for(j = 0; j < TC_NUM_SPECIALS; j++)
      if(g_player_data[i].m_player_specials[j] != 0)
        printf("%c", SpecialToChar(j + TC_SPECIAL_FIRST_SPECIAL));
    printf("\n");
  }
}

void InitPlayerData(struct TC_GameData *tc_game_data)
{
  int i, j;
  char *player_name;
  struct TC_PlayerData *tc_player_data;
  struct PlayerData *player_data;
  int own_player_number = 0;

  g_num_players = GetNumPlayers(tc_game_data);
  own_player_number = GetOwnPlayerNumber(tc_game_data);

  printf("num players = %d\n", g_num_players);

  for(i = 0; i < g_num_players; i++)
  {
    tc_player_data = GetPlayer(tc_game_data, i);

    player_data = &(g_player_data[i]);
    player_data->m_field = NULL;
    player_data->m_player_number = GetPlayerNumber(tc_player_data);
    if(player_data->m_player_number == own_player_number)
    {
      g_my_player_data = player_data;
      player_data->m_player_is_me = 1;
    } else {
      player_data->m_player_is_me = 0;
    }
    player_name = GetPlayerName(tc_player_data);
    if(strlen(player_name) > 1023)
    {
      strncpy(player_data->m_player_name, player_name, 1023);
      player_data->m_player_name[1023] = '\0';
    } else {
      strcpy(player_data->m_player_name, player_name);
    }
    player_data->m_player_active = 1;
    for(j = 0; j < TC_NUM_SPECIALS; j++)
    {
      player_data->m_field_specials[j] = 0;
      player_data->m_player_specials[j] = 0;
    }

    printf("initialised player %d: '%s'\n", player_data->m_player_number, player_data->m_player_name);
  }
}

void CleanUpPlayerData(void)
{
  int i;
  struct PlayerData *player_data;

  printf("cleanup!!\n");
  for(i = 0; i < g_num_players; i++)
  {
    player_data = &(g_player_data[i]);
    if(player_data->m_field != NULL)
      free(player_data->m_field);
    player_data->m_field = NULL;
  }
  printf("done cleanup\n");
}

void ReadFieldSpecials(char *field, int *specials)
{
  int i;

  if(field != NULL && specials != NULL)
  {
    for(i = 0; i < TC_NUM_SPECIALS; i++)
      specials[i] = 0;

    for(i = 0; i < TC_FIELD_HEIGHT * TC_FIELD_WIDTH; i++)
      if(field[i] >= TC_SPECIAL_FIRST_SPECIAL && field[i] <= TC_SPECIAL_LAST_SPECIAL)
          specials[field[i] - TC_SPECIAL_FIRST_SPECIAL]++;
  }
}

int HasSpecial(struct PlayerData *player_data, int special)
{
  return player_data->m_player_specials[special - TC_SPECIAL_FIRST_SPECIAL];
}

void UpdatePlayerSpecials(char *field, struct PlayerData *player_data)
{
  int tmp_specials[TC_NUM_SPECIALS];
  int i = 0;

  ReadFieldSpecials(field, tmp_specials);
  for(i = 0; i < TC_NUM_SPECIALS; i++)
  {
    if(tmp_specials[i] < player_data->m_field_specials[i])
    {
      player_data->m_player_specials[i]++;
      printf("think %s got a %d\n", player_data->m_player_name, i);
    }
    player_data->m_field_specials[i] = tmp_specials[i];
  }
}

int GetPlayerIndex(int n)
{
  int i;
  for(i = 0; i < g_num_players; i++)
  {
    if(g_player_data[i].m_player_number == n)
      return i;
  }

  return -1;
}

char *GetPlayerField(struct PlayerData *player_data)
{
  
  if(player_data->m_field != NULL)
    free(player_data->m_field);

  player_data->m_field = GetField(player_data->m_player_number);

  return player_data->m_field;
}

void UpdatePlayerData(void)
{
  int i, j;
  struct PlayerData *player_data;
  int from_player, to_player, special;
  float best_merit, last_merit;
  int best_merit_player, last_merit_player;

  g_num_alive_players = 0;

  while(GetSpecialNotification(&from_player, &to_player, &special) == 0)
  {

    printf("use of special %d from %d on %d\n", special, from_player, to_player);
    to_player = GetPlayerIndex(to_player);
    from_player = GetPlayerIndex(from_player);

    g_player_data[from_player].m_player_specials[special - TC_SPECIAL_FIRST_SPECIAL]--;

    switch(special)
    {
      case TC_SPECIAL_SWITCH_FIELDS:
        printf("recalc field specials\n");
        if(from_player != -1 && GetPlayerField(&(g_player_data[from_player])) != NULL)
          ReadFieldSpecials(g_player_data[from_player].m_field, g_player_data[from_player].m_field_specials);
        printf("done recalc field specials\n");
      case TC_SPECIAL_CLEAR_LINE:
      case TC_SPECIAL_BLOCK_GRAVITY:
      case TC_SPECIAL_NUKE:
      case TC_SPECIAL_CLEAR_RANDOM:        
        printf("recalc field specials 2\n");
         
        if(to_player != -1 && GetPlayerField(&(g_player_data[to_player])) != NULL)
          ReadFieldSpecials(g_player_data[to_player].m_field, g_player_data[to_player].m_field_specials);
        printf("done recalc field specials 2\n");
        break;
      case TC_SPECIAL_CLEAR_SPECIALS:
        if(to_player != -1)
        {
          for(i = 0; i < TC_NUM_SPECIALS; i++)
            g_player_data[to_player].m_field_specials[i] = 0;
        }
        break;
    }    
  }

  printf("g numb players = %d\n", g_num_players);
  for(i = 0; i < g_num_players; i++)
  {
    player_data = &(g_player_data[i]);

    if(GetPlayerField(player_data) != NULL)
    {
      UpdatePlayerSpecials(player_data->m_field, player_data);
      if(player_data->m_player_is_me)
      {
        GetSpecials(player_data->m_specials);
        for(j = 0; j < TC_NUM_SPECIALS; j++)
          player_data->m_player_specials[j] = 0;

        for(j = 0; j < player_data->m_specials[j] != 0; j++)
          player_data->m_player_specials[player_data->m_specials[j] - TC_SPECIAL_FIRST_SPECIAL]++;
    
      }
      player_data->m_field_merit = FieldMerit(player_data->m_field, &player_data->m_field_height);
printf("field merit returns: %f %d\n", player_data->m_field_merit, player_data->m_field);
      g_num_alive_players++;
    } else {
      player_data->m_player_active = 0;
      player_data->m_field_merit = -200000;
    }
  }

  best_merit = -20000;
  last_merit = 20000;

  best_merit_player = -1;
  last_merit_player = -1;

  for(i = 0; i < g_num_players; i++)
  {
    best_merit = -20000;
    for(j = 0; j < g_num_players; j++)
    {
      if(g_player_data[j].m_field_merit > best_merit && (g_player_data[j].m_field_merit < last_merit || (g_player_data[j].m_field_merit == last_merit &&  j > last_merit_player)))
      {
        best_merit = g_player_data[j].m_field_merit;
        best_merit_player = j;
      }
    }
    g_player_order[i] = &(g_player_data[best_merit_player]);
    last_merit = best_merit;
    last_merit_player = best_merit_player;
  }

  printf("num alive players =%d\n", g_num_alive_players);
  for(i = 0; i < g_num_alive_players; i++)
  {
    printf("%d. %s %f\n", i, g_player_order[i]->m_player_name, g_player_order[i]->m_field_merit);
  }
  PrintPlayersSpecials();
}


