/*
 *
 * Copyright (C) 2004, Laszlo Peter
 *
 * Nautilus is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Nautilus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Authors: Laszlo Peter <laca@sun.com>
 *
 */

#include <tclient.h>

typedef struct field_stats {
    int row_weight [TC_FIELD_HEIGHT];
    /* number of blocks in the given row */

    float row_density [TC_FIELD_HEIGHT];
    /* row_weight / TC_FIELD_WIDTH */

    int column_weight [TC_FIELD_WIDTH];
    /* number of blocks in the given column */

    int column_height [TC_FIELD_WIDTH];
    /* distance from the bottom of the topmost element in the column */

    int max_column_height;
    /* height of the highest column */

    int hole_depths [TC_FIELD_WIDTH];
    /* depth of the column at the top of the field measured from its 2
       neighbours */

    float column_density [TC_FIELD_WIDTH];
    /* weight of colument / height of column (NOT the height of the field */

    int specials_in_row [TC_FIELD_HEIGHT];
    /* number of special blocks in the row */

    int full_rows;
    /* number of full rows in the field */

    int num_deep_holes;
    /* number of holes deeper than 2 */

    int num_block_bombs;
    /* number of block bombs in the field */

    float avg_hole_depth;
    /* average depth of holes at the top */

    float avg_col_height;
    /* average height of columns */

    float field_density;
    /* weight of field / area of field measured to the top of each column */

    float row_blocked_ratio [TC_FIELD_HEIGHT];
    /* ratio of blocked holes in the row */

    float avg_hole_weight;
    /* average number of full blocks over blocked holes */

    float column_height_variance;
    /* variance of the column heights */

    float field_blocked_ratio;
    /* number of blocked holes in the field / area of the field */

    int num_rows_with_blocked_holes;
    /* number of rows that have blocked holes in them */

    int num_specials;
    /* total number of specials in the field */

    int specials_earned;
    /* number of specials in full rows */
} field_stats;

typedef char FIELD[TC_FIELD_HEIGHT][TC_FIELD_WIDTH];

