/*
 *
 * Copyright (C) 2004, Laszlo Peter
 *
 * Nautilus is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * Nautilus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Authors: Laszlo Peter <laca@sun.com>
 *
 */

#include <stdio.h>
#include "lacabot.h"

void print_field_with_stats(FIELD field, field_stats *stat)
{
    int i,j;
    char display;
    
    fprintf (stderr, "\nDEBUG: ");
    for (j=0; j<TC_FIELD_WIDTH; j++) {
	fprintf (stderr, " ");
    }
    fprintf (stderr, " weight  block%%  density\n");
    for (i = 0; i < TC_FIELD_HEIGHT; i++) {
	fprintf (stderr, "DEBUG: ");
	for (j = 0; j < TC_FIELD_WIDTH; j++) {
	    display = field[i][j];
	    display += 48;
	    fprintf (stderr, "%c", display);
	}
	fprintf (stderr, " %6d  %3.2f  %1.5f\n", stat->row_weight[i],
		 stat->row_blocked_ratio[i], stat->row_density[i]);
    }
    fprintf (stderr, "DEBUG: ");
    for (i = 0; i < TC_FIELD_WIDTH; i++) {
	fprintf (stderr, "%d", stat->hole_depths[i]);
    }
    fprintf (stderr, "\n");
    fprintf (stderr, "DEBUG: field density: %1.5f\n", stat->field_density);
    fprintf (stderr, "DEBUG: full rows: %d\n", stat->full_rows);
    fprintf (stderr, "DEBUG: avg_hole_weight: %f\n", stat->avg_hole_weight);
    fprintf (stderr, "DEBUG: column_height_variance: %f\n", stat->column_height_variance);
    fprintf (stderr, "DEBUG: num_deep_holes: %d\n", stat->num_deep_holes);
    fprintf (stderr, "\n");
    fflush (stderr);
}

static const char *special_names[] = {
    NULL, NULL, NULL, NULL, NULL, NULL,
    "ADD_LINE",
    "CLEAR_LINE",
    "NUKE",
    "CLEAR_RANDOM",
    "SWITCH_FIELDS",
    "CLEAR_SPECIALS",
    "BLOCK_GRAVITY",
    "BLOCK_QUAKE",
    "BLOCK_BOMB"};

const char *debug_get_spec_name(char c) {
    return special_names[c];
}
