#include "bot.hpp"

blocks_class *block = NULL;

bool bot::test_line_empty(char *field,int row)
{
	bool flag = true;
	for(int i = 0;i<TC_FIELD_WIDTH;i++)
	{
		if(test_square_status(field,i,row)!=0)
		{
			flag = false;
		}
	}
	return(flag);
}
	
int bot::test_max_height(char *field)
{
	int row = 0;
	int col = 0;
	bool flag = true;
	while(flag && row< TC_FIELD_HEIGHT)
	{
		if(	test_line_empty(field,row))
		{
			flag = false;	
		}
	}
	return(row);
}

int bot::test_complete_rows()
{
	return(test_complete_rows(field));
}

/*bool bot::test_full_line(char *bitmap)
{
	
	
}*/


int bot::test_complete_rows(char *bitmap)
{
	int result = 0;
	bool flag = true;
	for(int i = 0;i<TC_FIELD_HEIGHT;i++)
	{
		flag = true;
		for(int j = 0;j<TC_FIELD_WIDTH;j++)
		{
			if(test_square_status(bitmap,j,i) == 0)
			{
				flag == false;
			}
		}
		if(!flag)
		{
			result++;
		}
	}		
	return(result);
}


char * bot::create_field_with_block(char*current_field,int block_id,int x,int y)
{
	char* newfield = new char[TC_FIELD_SIZE * TC_FIELD_WIDTH];
	memcpy(newfield,current_field,TC_FIELD_SIZE);
	for(int i = 0;i<4;i++)
	{
		for(int j = 0;j<4;j++)
		{
			if(test_block_square(block_id,j,i)>0)
			{
				newfield[((i+y)*TC_FIELD_WIDTH)+(j+x)] =1;
			}
		}
	}
	return(newfield);
}
	
int bot::compare_fields(char* field1,char*field2)
{
	int differences = 0;
	for(int i = 0;i<TC_FIELD_HEIGHT;i++)
	{
		for(int j= 0;j<TC_FIELD_WIDTH;j++)
		{
		
			if(test_square_status(field1,j,i) != test_square_status(field2,j,i))
			{
				differences++;
			}
		}
	}
	return(differences);
}
	
	
float bot::score_block(int block_id, int xpos, int ypos)
{
	float gap1,gap2,side,height,full_line;
	char * tempfield = create_field_with_block(field,block_id, xpos, ypos);
	float score = 0;
	full_line = full_line_score * test_complete_rows(tempfield);
	gap1 = (gap_score * test_block_for_gaps(block_id, xpos, ypos));
	height =  height_score * ypos;
	side =  side_score * fabs(xpos - ((TC_FIELD_WIDTH / 2)-1));
	gap2 = field_gap_score * test_field_for_gaps(tempfield);
	

	delete [] tempfield;
	return(gap1+gap2+side+height);
}



void bot::dump_state()
{
	if (field != NULL)
	{
		cout<<"gaps: "<<test_field_for_gaps()<<endl;
		cout<<"gaps under block: "<<test_block_for_gaps(block_type,xpos,ypos)<<endl;
		cout<<"block score : "<<score_block(block_type,xpos,ypos)<<endl;
		for(int i=0; i<TC_FIELD_HEIGHT;i++)
		{
			for(int j=0; j<TC_FIELD_WIDTH;j++)
			{
				//if(field[i*TC_FIELD_WIDTH +j] == 0)
				if(test_square_status(j,i) == 0)
				{
					cout<<"o";
				}
				else
				{
					cout<<"X";
				}
			}
			cout<<endl;
			
		}
	}
}

void bot::dump_state(char *bitmap)
{
	for(int i=0; i<TC_FIELD_HEIGHT;i++)
	{
		for(int j=0; j<TC_FIELD_WIDTH;j++)
		{
			//if(field[i*TC_FIELD_WIDTH +j] == 0)
			if(test_square_status(bitmap,j,i) == 0)
			{
				cout<<"o";
			}
			else
			{
				cout<<"X";
			}
		}
		cout<<endl;	
	}	
}
int bot::test_square_status(int x,int y)
{
	if((x < 0) || (x >= TC_FIELD_WIDTH) || (y < 0) || (y >= TC_FIELD_HEIGHT))
	{
		return(1);
	}
	if (field[y*TC_FIELD_WIDTH +x] != 0)
	{
		return(1);
	}
	return(0);
}

int bot::test_square_status(char* bitmap,int x,int y)
{
	if((x < 0) || (x >= TC_FIELD_WIDTH) || (y < 0) || (y >= TC_FIELD_HEIGHT))
	{
		return(1);
	}
	if (bitmap[y*TC_FIELD_WIDTH +x] != 0)
	{
		return(1);
	}
	return(0);
}
int bot::test_block_square(int block_id, int x,int y)
{
	if((x < 0) ||(x >= 4) || (y < 0) || (y >= 4) || (block_id < 0) || (block_id >= NUMBER_OF_BLOCKS ))
	{
		return(0);
	}
	return(block->bitmap[block_id][y*4+x]);
}

int bot::test_column_for_gaps(int column)
{
	int counter = 0;
	int row = 0;
	while (row<=TC_FIELD_HEIGHT && test_square_status(column,row) ==0)
	{
		row++;
	}
	while (row<=TC_FIELD_HEIGHT)
	{
		row++;
		if (test_square_status(column,row) ==0)
		{
			counter++;
		}
	}
	return(counter);
}
int bot::test_column_for_gaps(char* bitmap,int column)
{
	int counter = 0;
	int row = 0;
	while (row<=TC_FIELD_HEIGHT && test_square_status(bitmap,column,row) ==0)
	{
		row++;
	}
	while (row<=TC_FIELD_HEIGHT)
	{
		row++;
		if (test_square_status(bitmap,column,row) ==0)
		{
			counter++;
		}
	}
	return(counter);
}
int bot::test_block_for_gaps(int block_id, int xpos, int ypos)
{
	int counter =0;
	//cout<<"Block: "<<block_id<<endl;
	for(int i = 0; i<4; i++)
	{
		int row = 0;
		bool flag = true;
		while( (row < 4) && flag)
		{
			if(test_block_square(block_id,i,row) == 1)
			{
				flag = false;
				while(test_block_square(block_id,i,row) == 1)
				{
					row++;
				}
				while ((row<=(TC_FIELD_HEIGHT-ypos)) && (test_square_status(i+xpos,row+ypos) ==0) )
				{
					counter++;
					row++;
				}
			}
			else
			{				
				row++;
			}
		}
	}
	return(counter);
}

int bot::test_field_for_gaps()
{
	int counter = 0;
	for(int i = 0; i<=TC_FIELD_WIDTH; i++)
	{
		counter = counter + test_column_for_gaps(i);
	}
	return(counter);
}

int bot::test_field_for_gaps(char* bitmap)
{
	int counter = 0;
	for(int i = 0; i<=TC_FIELD_WIDTH; i++)
	{
		counter = counter + test_column_for_gaps(bitmap,i);
	}
	return(counter);
}

int bot::test_block_position(int test_block,int x,int y)
{
	if(test_block<0 || test_block >= NUMBER_OF_BLOCKS)
	{
		return(16);
	}
	int result = 0;
	for(int i = 0; i<4; i++)
	{
		for(int j=0; j<4; j++)
		{
			if(block->bitmap[test_block][i*4+j] == 1)
			{
				if(test_square_status(x+j, y+i) == 1)
				{
					result++;
				}
				if((y+i) > TC_FIELD_HEIGHT || (y+i) < 0 || (x+j) > TC_FIELD_WIDTH || (x+j) < 0)
				{
					result++;
				}
			}
		}
		
	}
	return(result);
}

void bot::get_field()
{
	field = GetField(my_player_number);
	if (field == NULL)
	{
		status = edead;
	}
}

int bot::handle_messages()
{
	int number_of_messages = 0;
	int player;
	char * message;
	while (GetMessage(&player, &message)==0)
	{
		#ifdef debug_bot
		cout<<"Message from Player "<<player<<" : "<<message<<endl;
		#endif
		free((void*)message);
		number_of_messages++;
	}
	return(number_of_messages);
}

int bot::find_lowest_row(int block_id,int column)
{
	int tempy = 0;
	while(tempy < TC_FIELD_HEIGHT &&  test_block_position(block_id,column,tempy) == 0)
	{
		tempy++;
	}
	return((tempy-1));
}

void bot::play()
{
	get_field();
	//while (status!=edead)
if(status!=edead)
{	
	result = GetCurrentBlock(&block_type, &xpos, &ypos);
	//cout<<"Block type: "<<block_type<<endl;
	if(block_type != TC_BLOCK_NONE)
	{
		iterations++;
		char *new_bitmap;
		int position =5;
		int rotation =0;
		int current_block = block_type;
		int chosen_block;
		float maxscore=-10000;
		float score;
		for(int j =0 ;j < block->number_in_series[block_type]; j++)
		{
		for(int i =-2; i < TC_FIELD_WIDTH; i++) 
		{
			if(test_block_position(current_block,i,ypos) == 0)
			{	
				score = score_block(current_block,i,find_lowest_row(current_block,i));
				if (score >=maxscore)
				{
					maxscore = score;
					position = i;
					rotation = j;
					chosen_block = current_block;
				}					
			}
		}
		
		current_block = block->next[current_block];
		}
		new_bitmap = create_field_with_block(field,chosen_block,position,find_lowest_row(chosen_block,position));
		for(int i = 0; i<rotation; i++)
		{
			MoveBlock(TC_ROTATE_ANTICLOCKWISE);
		}
		while(xpos < position)
		{
			MoveBlock(TC_MOVE_RIGHT);
			xpos++;
		}
		while(xpos > position)
		{
			MoveBlock(TC_MOVE_LEFT);
			xpos--;
		}
		
		GetCurrentBlock(&block_type, &xpos, &ypos);
		MoveBlock(TC_MOVE_DROP);
		get_field();
		delete [] new_bitmap;
	}
	handle_specials();
	if(status != edead)
	{
		//handle_messages();
	}
	//sleep(1);
}	
}

int bot::connect()
{
	
	if(server == NULL)
	{
		if (connectToServer("127.0.0.1",9467,username,team,"") != 0)
		{
			#ifdef debug_bot
				cout<<"Failed to connect to server. Error: "<<tc_error_string<<endl;
			#endif
			return(1);
		}
	}
	else
	{
		if (connectToServer(server,9467,username,team,"") != 0)
		{
			#ifdef debug_bot
				cout<<"Failed to connect to server. Error: "<<tc_error_string<<endl;
			#endif
			return(1);
		}
		
	}
	
	return(0);
}

int bot::wait_for_start()
{
	if(Start(&gamedata)!=0)
	{
		#ifdef debug_bot
			cout<<"Error waiting for game to start"<<endl;
		#endif
		return(1);
	}
	status = eplaying;
	iterations = 0;
	my_player_number = GetOwnPlayerNumber(gamedata);
	#ifdef debug_bot
	cout<<"My player number: "<<my_player_number<<endl;
	#endif
	specials = new char[GetMaxSpecials(gamedata)];
	
	number_of_players = GetNumPlayers(gamedata);
	#ifdef debug_bot
	cout<<"number of players: "<<number_of_players<<endl;
	#endif
	/*playerdata = new player[number_of_players];
	for(int i=0;i<number_of_players;i++)
	{
		playerdata[i]->number=
		
	}*/
	return(0);
	
}

int bot::game_status()
{
	return(GetCurrentBlock(&block_type, &xpos, &ypos));
}


int bot::find_random_player()
{
	char *field;
	int players[10];
	int count = 0;
	#ifdef debug_bot
		cout<<"find random player"<<endl;
	#endif
	for(int i = 0;i<number_of_players;i++)
	{
		
		if(i != my_player_number)
		{
			
			field = GetField(i);
			if(field != NULL)
			{
				
				delete [] field;
				players[count] = i;
				count++;
			}
		}
	}
	if(count == 0)
	{
		return(-1);
	}
	return(players[random()%count]);
}
		
	
	
int bot::find_player_lowest_block()
{
	int player =-1;
	int min_row =TC_FIELD_HEIGHT;
	int new_row;
	char *field;
	for (int i = 0;i< number_of_players;i++)
	{
		if ( i!= my_player_number)
		{
			field = GetField(i);
			if (field != NULL)
			{
				new_row = test_max_height(field);
				if(new_row < min_row)
				{
					min_row = new_row;
					player = i;
				}
				delete [] field;
			}
		}
	}
	#ifdef debug_bot
		cout<<"min picked "<<player<<endl;
	#endif
	return(player);
}

	
int bot::find_player_highest_block()
{
	int player =-1;
	int max_row = 0;
	int new_row;
	char *field;
	for (int i = 0;i< number_of_players;i++)
	{
		if ( i!= my_player_number)
		{
			field = GetField(i);
			if (field != NULL)
			{
				new_row = test_max_height(field);
				if(new_row > max_row)
				{
					max_row = new_row;
					player = i;
				}
				delete [] field;
			}
		}
	}
	#ifdef debug_bot
		cout<<"max picked "<<player<<endl;
	#endif
	return(player);
}




void bot::handle_specials()
{
	number_of_players = GetNumPlayers(gamedata);
	//#ifdef 
	//cout<<"number of players: "<<number_of_players<<endl;
	int player;
	GetSpecials(specials);
	if(specials[0] != NULL)
	{
		switch(specials[0])
		{
			case TC_SPECIAL_ADD_LINE:
				player = find_player_lowest_block();
				if (player == -1)
				{
					DiscardSpecial();
				}
				else
				{
					UseSpecial(player);
				}
				break;
			case TC_SPECIAL_CLEAR_SPECIALS:
				player = find_random_player();
				if (player == -1)
				{
					DiscardSpecial();
				}
				else
				{
					UseSpecial(player);
				}
				break;
			
			case TC_SPECIAL_CLEAR_LINE://DiscardSpecial();
				UseSpecial(my_player_number);
				break;
			case TC_SPECIAL_NUKE:
				if (test_max_height(field) < 6)
				{
					DiscardSpecial();
				}
				else
				{
					UseSpecial(my_player_number);
				}
				break;
			case TC_SPECIAL_BLOCK_BOMB:
				player = find_player_lowest_block();
				if (player == -1)
				{
					DiscardSpecial();
				}
				else
				{
					UseSpecial(player);
				}
				break;
			case TC_SPECIAL_CLEAR_RANDOM:
				player = find_random_player();
				if (player == -1)
				{
					DiscardSpecial();
				}
				else
				{
					UseSpecial(player);
				}
				break;
			case TC_SPECIAL_SWITCH_FIELDS:
				player = find_player_lowest_block();
				if (player == -1)
				{
					DiscardSpecial();
				}
				else
				{
					char *player_field = GetField(player);
					if (player_field != NULL)
					{
						if(test_max_height(field) > test_max_height(player_field))
						{
							UseSpecial(player);
						}
						else
						{
							DiscardSpecial();
						}
					}
					else
					{
						DiscardSpecial();
					}
				}
				break;
			default:
				DiscardSpecial();
				break;
		}	
		
	}
			
}
