#ifndef _TETRINET_FIELD_H
#define _TETRINET_FIELD_H

class TetrinetField;

#include "TetrinetServer.h"

class TetrinetField
{
public:
	TetrinetField(char *field);
	TetrinetField(TetrinetField &i, bool copy);
	TetrinetField(TetrinetField *i, bool copy);
	bool canPlace(int b, int x, int y, bool gravity=true);
	bool findPath(BlockStatus b, int x, int y, int *path, int xdir=0);
	int placeBlock(BlockStatus b, int x, int y);
	int simulateDrop(BlockStatus b, int x);
	int getHeight();
	void getStats(int *height, int *heightSd, int *minHeight, int *totalTrough, int *numTrough, int *deepestTrough);
	int getInaccessable();
	float getHorizEntropy();
	float getVertEntropy();
	int getHeightSd();
	~TetrinetField();
	char *field;
	void printField();
	bool isEqual(TetrinetField *i);
};

#endif
