/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: speshal.c,v 1.56 2004/01/16 04:57:34 khalek Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "speshal.h"
#include "tclient.h"
#include "tetris.h"
#include "util.h"

/* returns a random number in the range 0 to n-1 --
 * Note both n==0 and n==1 always return 0 */
int randomnum(int n)
{
	return (float)n*rand()/(RAND_MAX+1.0);
}

void useSpeshals(struct TC_GameData *gData)
{
	int i;
	char *playerTeam, *tmpTeam;
 
	spPath toUse;
	char *specials;
	int numPlayers, ownNumber;
	fields initialFields;
	double lastFieldRates[6];
	int onTeam[6];

	/* zero init array */
	for (i = 0; i < 6; i++)
		onTeam[i] = 0;
	
	debug(1, "Calculating specials.\n");

	toUse.depth = 0;
	toUse.rate = 0;
	toUse.player = NULL;

	specials = (char *)malloc(sizeof(char) * GetMaxSpecials(gData));
	GetSpecials(specials);

	/* Added 1 because this function is all broken - UPDATE seems to be fixed now */
	numPlayers = GetNumPlayers(gData);
	ownNumber = GetOwnPlayerNumber(gData);
	
	playerTeam = (char *)malloc(sizeof(char) * TEAM_STR_LENGTH);
	tmpTeam = (char *)malloc(sizeof(char) * TEAM_STR_LENGTH);
	/* **FIXME** breaks - why?? */
	/* playerTeam = GetPlayerTeam(GetPlayer(gData, ownNumber)); */
	/* alternative (no team support): */
	onTeam[ownNumber] = 1;
	for(i = 0; i < 6; i++)
	{
		initialFields[i] = GetField(i);

		lastFieldRates[i] = rateField(initialFields[i]);

		/* tmpTeam = GetPlayerTeam(GetPlayer(gData, i));
		if(tmpTeam[0] != NULL)
			if(!strcmp(playerTeam, tmpTeam))
				onTeam[i] = 1; */
	}
	free(playerTeam);
	free(tmpTeam);

	debug(1, "Beginning special recursion.\n");

	toUse = getSpPath(initialFields, specials, numPlayers, lastFieldRates, onTeam, ownNumber, toUse);

	freeFields(initialFields);

	debug(1, "Using Specials\n");

	if(toUse.rate > SPECIAL_THRESHHOLD)
	{
		for(i = 0; i < toUse.depth; i++)
		{
			if(toUse.player[i] >= numPlayers)
				DiscardSpecial();
			else
			{
				if(UseSpecial(toUse.player[i]))
					DiscardSpecial();
			}
		}
	}

	free(specials);
	debug(1, "Specials Complete.\n");
}

void specialAddLine(char *field)
{
	int x, y, i;
	
	/* check top row */
	for (x = 0; x < TC_FIELD_WIDTH; x++)
	{
		if (getFieldPos(field, x, 0))
		{
			for (x = 0; x < TC_FIELD_WIDTH; x++)
				getFieldPos(field, x, 0) = 1;
			return;
		}
	}
	/* move everything up one */
	for (y = 0; y < TC_FIELD_HEIGHT - 1; y++)
		for (x = 0; x < TC_FIELD_WIDTH; x++)
			getFieldPos(field, x, y) = getFieldPos(field, x, y + 1);
	/* generate a random line with spaces in it */
	for (x = 0; x < TC_FIELD_WIDTH; x++)
		getFieldPos(field, x, TC_FIELD_HEIGHT - 1) = 1;
	/* add a single space */
	getFieldPos(field, randomnum(TC_FIELD_WIDTH), TC_FIELD_HEIGHT - 1) = 0;
}

void specialClearSpecials(char *field)
{
	int x;
	for(x = 0; x < TC_FIELD_SIZE; x++)
		if(field[x] >= TC_SPECIAL_FIRST_SPECIAL && field[x] <= TC_SPECIAL_LAST_SPECIAL)
			field[x] = 1;
}

void specialClearLine(char *field)
{
	int y, x;

	for(y = TC_FIELD_HEIGHT - 1; y > 0; y--)
		for(x = 0; x < TC_FIELD_WIDTH; x++)
			getFieldPos(field, x, y) = getFieldPos(field, x, y - 1);

	for(x = 0; x < TC_FIELD_WIDTH; x++)
		getFieldPos(field, x, 0) = 0;
}

void specialBlockGravity(char *field)
{
	int x, y, i, needToMove;

	for (y = 0; y < TC_FIELD_HEIGHT; y++)
		for (x = 0; x < TC_FIELD_WIDTH; x++)
			if (getFieldPos(field, x, y) == 0) {
				/* move the above blocks down */
				for (i = y; i > 0; i --)
					getFieldPos(field, x, i) = getFieldPos(field, x, i - 1);
				getFieldPos(field, x, 0) = 0;
			}

	needToMove = 0;
	/* Check to see if we should move the field down */
	for (y = TC_FIELD_HEIGHT - 1; y >= 0; y--)
		for (x = 0; x < TC_FIELD_WIDTH; x++)
			if (!getFieldPos(field, x, y))
			{
				needToMove = (TC_FIELD_HEIGHT - 1) - y;
				y = -1;
				x = TC_FIELD_WIDTH;
			}

	if(needToMove)
	{
		/* need to move field down needToMove lines */
		for (y = TC_FIELD_HEIGHT-1; y >= needToMove; y--)
			for (x = 0; x < TC_FIELD_WIDTH; x++)
				getFieldPos(field, x, y) = getFieldPos(field, x, y-needToMove);
		for (y = 0; y < needToMove; y++)
			for (x = 0; x < TC_FIELD_WIDTH; x++)
				getFieldPos(field, x, y) = 0;
	}
}

void specialNuke(char *field)
{
	int x;

	for (x = 0; x < TC_FIELD_SIZE; x++)
		field[x] = 0;
}

void specialBlockBomb(char *field)
{
	int ax[] = {-1, 0, 1, 1, 1, 0, -1, -1};
	int ay[] = {-1, -1, -1, 0, 1, 1, 1, 0};
	int c = 0;
	int x, y, i;
	char block;
	char buf[512];

	/* find all bomb blocks */
        for (y = 0; y < TC_FIELD_HEIGHT; y ++)
                for (x = 0; x < TC_FIELD_WIDTH; x ++)
			if (getFieldPos(field, x, y) == 14) {
                                /* remove the bomb */
				getFieldPos(field, x, y) = 0;
                                /* grab the squares around it */
                                for (i = 0; i < 8; i ++) {
                                        if (y+ay[i] >= TC_FIELD_HEIGHT || y+ay[i] < 0 
						|| x+ax[i] >= TC_FIELD_WIDTH || x+ax[i] < 0) continue;
					block = getFieldPos(field, x + ax[i], y + ay[i]);
                                        if (block == 14) 
						block = 0;
                                        else
						getFieldPos(field, x + ax[i], y + ay[i]) = 0;
                                        buf[c] = block;
                                        c ++;
                                }
                        }
        /* scatter blocks */
        for (i = 0; i < c; i ++)
		getFieldPos(field, randomnum(TC_FIELD_WIDTH), randomnum(TC_FIELD_HEIGHT - 6) + 6) = buf[i];
}

void specialBlockQuake(char *field)
{
	int i, y;
	for (y = 0; y < TC_FIELD_HEIGHT; y++) {
                /* [ the original approximation of blockquake frequencies were
                         not quite correct ] */
                /* ### This is a much better approximation and probably how the */
                /* ### original tetrinet does it */
		int s = 0;
		i = randomnum(22);
		if (i < 1) s++;
		if (i < 4) s++;
		if (i < 11) s++;
		if (randomnum(2)) s = -s;
		tetrinetShiftline(y, s, field);
	}
}

void specialClearRandom(char *field)
{
	int i;
	for (i = 0; i < 10; i++)
			getFieldPos(field, randomnum(TC_FIELD_WIDTH), randomnum(TC_FIELD_HEIGHT)) = 0;
}

void specialSwitchFields(char *field, char *field2)
{
	int x, y, needToMove;
	char *tmpField = (char *) malloc(TC_FIELD_SIZE);
	memcpy(tmpField, field, TC_FIELD_SIZE);
	memcpy(field, field2, TC_FIELD_SIZE);
	memcpy(field2, tmpField, TC_FIELD_SIZE);
	free(tmpField);

	/* Check to see if we should move the field down */
	needToMove = 0;
	for(y = 0; y < 6; y++)
		for(x = 0; x < TC_FIELD_WIDTH; x++)
			if(getFieldPos(field, x, y))
			{
				needToMove = 6 - y;
				y = 6;
				x = TC_FIELD_WIDTH;
			}

	if(needToMove)
	{
		/* need to move field down needToMove lines */
		for(y = TC_FIELD_HEIGHT-1; y >= needToMove; y--)
			for(x = 0; x < TC_FIELD_WIDTH; x++)
				getFieldPos(field, x, y) = getFieldPos(field, x, y-needToMove);
		for (y = 0; y < needToMove; y++)
			for (x = 0; x < TC_FIELD_WIDTH; x++)
				getFieldPos(field, x, y) = 0;
	}
}

spPath getSpPath(fields previousFields, char *specials, int numPlayers, double lastFieldRates[6], int onTeam[6], int ownNumber, spPath previousPath)
{
	int i, j;
	double newFieldRates[6];
	spPath branchPath, currentPath, tmpPath;
	fields branchFields;

	if(specials[previousPath.depth] == (char)NULL || previousPath.depth > SPECIAL_RECURSE_DEPTH)
	{
		tmpPath.depth = previousPath.depth;
		tmpPath.rate = previousPath.rate;
		tmpPath.player = (int *)malloc(sizeof(int) * previousPath.depth);
		for(i = 0; i < previousPath.depth; i++)
			tmpPath.player[i] = previousPath.player[i];
		return tmpPath;
	}

	currentPath.depth = previousPath.depth;
	currentPath.rate = previousPath.rate;
	currentPath.player = (int *)malloc(sizeof(int) * currentPath.depth);
	for(i = 0; i < currentPath.depth; i++)
		currentPath.player[i] = previousPath.player[i];


	for(i = numPlayers; i >= 0; i--)
	{
		debug(2, "Try special depth %d on player: %d\n", previousPath.depth+1, i);
		for(j = numPlayers - 1; j >= 0; j--)
			newFieldRates[j] = lastFieldRates[j];
		branchPath.depth = previousPath.depth + 1;
		branchPath.player = (int *)malloc(sizeof(int) * branchPath.depth);
		for(j = 0; j < previousPath.depth; j++)
			branchPath.player[j] = previousPath.player[j];
		branchPath.player[branchPath.depth - 1] = i;
		copyFields(previousFields, branchFields);
		branchPath.rate = previousPath.rate;

		if(i != numPlayers)
		{
			switch(specials[previousPath.depth])
			{
				case TC_SPECIAL_ADD_LINE:
					specialAddLine(branchFields[i]);
					break;
				case TC_SPECIAL_CLEAR_SPECIALS:
					specialClearSpecials(branchFields[i]);
					break;
				case TC_SPECIAL_CLEAR_LINE:
					specialClearLine(branchFields[i]);
					break;
				case TC_SPECIAL_BLOCK_GRAVITY:
					specialBlockGravity(branchFields[i]);
					break;
				case TC_SPECIAL_NUKE:
					specialNuke(branchFields[i]);
					break;
				case TC_SPECIAL_BLOCK_BOMB:
					specialBlockBomb(branchFields[i]);
					break;
				case TC_SPECIAL_BLOCK_QUAKE:
					specialBlockQuake(branchFields[i]);
					break;
				case TC_SPECIAL_CLEAR_RANDOM:
					specialClearRandom(branchFields[i]);
					break;
				case TC_SPECIAL_SWITCH_FIELDS:
					specialSwitchFields(branchFields[i], branchFields[ownNumber]);
					newFieldRates[ownNumber] = rateField(branchFields[ownNumber]);
					branchPath.rate -= newFieldRates[ownNumber] - lastFieldRates[ownNumber];
					break;
			}
			newFieldRates[i] = rateField(branchFields[i]);
			if(onTeam[i])
				branchPath.rate -= newFieldRates[i] - lastFieldRates[i];
			else
				branchPath.rate += newFieldRates[i] - lastFieldRates[i];
		}
		else
			branchPath.rate = previousPath.rate;

		tmpPath = getSpPath(branchFields, specials, numPlayers, newFieldRates, onTeam, ownNumber, branchPath);
		currentPath = comparePaths(currentPath, tmpPath, specials);
		freeFields(branchFields);
		free(branchPath.player);
		/* Only way i could neatly add null avoidance, is a bit dodgy */
		if(i != 0)
			while(i > 0 && previousFields[i-1] == NULL)
				i--;
	}
	return currentPath;
}

spPath comparePaths(spPath t1, spPath t2, char *specials)
{
	int i;
	double t1rate, t2rate, t1cost, t2cost;
	spPath toReturn;

	t1rate = t1.rate;
	t2rate = t2.rate;

	t1cost = t2cost = 0;
	for(i = 0; i < t1.depth; i++)
		t1cost += specialScore(specials[i]);
	for(i = 0; i < t2.depth; i++)
		t2cost += specialScore(specials[i]);

	t1rate /= t2cost;
	t2rate /= t2cost;

	if(t1rate > t2rate)
	{
		toReturn.depth = t1.depth;
		toReturn.rate = t1.rate;
		debug(2, "Compare Depth: %d\n", t1.depth);
		toReturn.player = (int *)malloc(sizeof(int) * t1.depth);
		for(i = 0; i < t1.depth; i++)
			toReturn.player[i] = t1.player[i];
	}
	else
	{
		toReturn.depth = t2.depth;
		toReturn.rate = t2.rate;
		debug(2, "Compare Depth: %d\n", t2.depth);
		toReturn.player = (int *)malloc(sizeof(int) * t2.depth);
		for(i = 0; i < t2.depth; i++)
			toReturn.player[i] = t2.player[i];
	}
	free(t1.player);
	free(t2.player);
	return toReturn;
}

void copyFields(fields toCopy, fields store)
{
	int i, x;

	for(i = 0; i < 6; i++)
	{
		if(toCopy == NULL || toCopy[i] == NULL)
			store[i] = NULL;
		else
		{
			store[i] = (char *)malloc(sizeof(char) * TC_FIELD_SIZE);
			memcpy(store[i], toCopy[i], TC_FIELD_SIZE);
		}
	}
}

void freeFields(fields toFree)
{
	int i;

	for(i = 0; i < 6; i++)
		free(toFree[i]);
}
