/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: util.c,v 1.2 2004/01/16 00:56:37 khalek Exp $
 */
#include <stdarg.h>
#include <stdio.h>

int debugLevel = -1;

/* printf wrapper controlled via command line parameter
 * to be used to allow verbosity of output to be scaled
 * at runtime
 */
void debug(int level, const char *s, ...) {
	char buf[1024];
		va_list va;

	if (level > debugLevel)
		return;

	va_start(va, s);
	vsprintf(buf, s, va);
	va_end(va);
	printf("%s", buf);
}

