/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TETRIS_H
#define TETRIS_H

#include "tcommon.h"

#define getFieldPos(field, x, y) field[(y) * TC_FIELD_WIDTH + (x)]

void placePiece(struct TC_GameData *gData);
double rateField(char *field);
double rateRow(char *field, int row);
double ratePlayerField(int playerNumber);
char* addToField(char *field, char piece, int pos);
int colHeight(char* field, int col);
void printField(char *field);
void detectProblem(char *field, char* keptField);
int specialScore(char special);
void tetrinetShiftline(int line, int shift, char* field);


/* map of blocks starting top leftmost pos 
 * [blocktype][x][y]
 */

static char blockmap[20][4][4] = {
 { {0,0,0,0}, {0,0,0,0}, {0,0,0,0}, {0,0,0,0} }, /* 0 */
 { {0,0,0,0}, {1,1,0,0}, {1,1,0,0}, {0,0,0,0} }, /* 1 */
 { {2,0,0,0}, {2,0,0,0}, {2,0,0,0}, {2,0,0,0} }, /* 2 */
 { {0,0,0,0}, {0,0,0,0}, {2,2,2,2}, {0,0,0,0} }, /* 3 */
 { {0,0,0,0}, {0,3,0,0}, {3,3,0,0}, {3,0,0,0} }, /* 4 */
 { {0,0,0,0}, {3,3,0,0}, {0,3,3,0}, {0,0,0,0} }, /* 5 */
 { {0,0,0,0}, {4,0,0,0}, {4,4,0,0}, {0,4,0,0} }, /* 6 */
 { {0,0,0,0}, {0,4,4,0}, {4,4,0,0}, {0,0,0,0} }, /* 7 */
 { {0,0,0,0}, {5,5,0,0}, {5,0,0,0}, {5,0,0,0} }, /* 8 */
 { {0,0,0,0}, {5,5,5,0}, {0,0,5,0}, {0,0,0,0} }, /* 9 */
 { {0,0,0,0}, {0,5,0,0}, {0,5,0,0}, {5,5,0,0} }, /* 10 */
 { {0,0,0,0}, {5,0,0,0}, {5,5,5,0}, {0,0,0,0} }, /* 11 */
 { {0,0,0,0}, {6,0,0,0}, {6,0,0,0}, {6,6,0,0} }, /* 12 */
 { {0,0,0,0}, {6,6,6,0}, {6,0,0,0}, {0,0,0,0} }, /* 13 */
 { {0,0,0,0}, {6,6,0,0}, {0,6,0,0}, {0,6,0,0} }, /* 14 */
 { {0,0,0,0}, {0,0,6,0}, {6,6,6,0}, {0,0,0,0} }, /* 15 */
 { {0,0,0,0}, {7,0,0,0}, {7,7,0,0}, {7,0,0,0} }, /* 16 */
 { {0,0,0,0}, {7,7,7,0}, {0,7,0,0}, {0,0,0,0} }, /* 17 */
 { {0,0,0,0}, {0,7,0,0}, {7,7,0,0}, {0,7,0,0} }, /* 18 */
 { {0,0,0,0}, {0,7,0,0}, {7,7,7,0}, {0,0,0,0} }  /* 19 */
};

/* Rating modifiers */
#define RATE_CAVES 15
#define RATE_BLOCKCOUNT 1
#define RATE_UNFILLABLE .5
#define RATE_HEIGHT .2
#define RATE_GET_SPECIAL 2
#define RATE_GET_1_LINE 100
#define RATE_GET_2_LINES 500
#define RATE_GET_3_LINES 1000
#define RATE_GET_4_LINES 3000

/* Special ratings */
#define RATE_SPECIAL_ADD_LINE 1
#define RATE_SPECIAL_CLEAR_SPECIALS 2
#define RATE_SPECIAL_CLEAR_LINE 1
#define RATE_SPECIAL_BLOCK_GRAVITY 5
#define RATE_SPECIAL_NUKE 5
#define RATE_SPECIAL_BLOCK_BOMB 4
#define RATE_SPECIAL_BLOCK_QUAKE 3
#define RATE_SPECIAL_CLEAR_RANDOM 2
#define RATE_SPECIAL_SWITCH_FIELDS 6

#endif
