/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: test_specials.c,v 1.1 2004/01/10 10:28:41 khalek Exp $ 
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "speshal.h"
#include "tclient.h"
#include "tetris.h"
#include "util.h"

int main() {
	char ch;
	int x, y;
		
	debugLevel = 2;
	srand(time(NULL));
	
	printf("testing specialAddLine()\n");
	char *field = (char *) calloc(TC_FIELD_SIZE, 1);
	/* add some existing blocks */
	for (x = 0; x < 4; x++)
		getFieldPos(field, x, 21) = 1;
	specialAddLine(field);
	printField(field);
	/* pause for input */
	scanf("%c", &ch);


	printf("testing specialClearLine()\n");
	specialClearLine(field);
	printField(field);
	scanf("%c", &ch);

	printf("setting up for clear random,,,\n");
	for (x = 0; x < TC_FIELD_WIDTH; x++)
		for (y = TC_FIELD_HEIGHT - 1; y > (TC_FIELD_HEIGHT / 2); y--)
			getFieldPos(field, x, y) = 1;
	printField(field);
	scanf("%c", &ch);

	printf("testing specialClearRandom()\n");
	specialClearRandom(field);
	printField(field);
	scanf("%c", &ch);

	printf("setting up for block quake...\n");
	for (x = 0; x < TC_FIELD_WIDTH; x++)
		for (y = TC_FIELD_HEIGHT - 1; y > (TC_FIELD_HEIGHT / 2); y--)
			getFieldPos(field, x, y) = 1;
	/* empty line down the middle */
	for (y = TC_FIELD_HEIGHT - 1; y > (TC_FIELD_HEIGHT / 2); y--)
		getFieldPos(field, (TC_FIELD_WIDTH / 2), y) = 0;
	printField(field);
	scanf("%c", &ch);
	
	printf("testing specialBlockQuake()\n");
	specialBlockQuake(field);
	printField(field);
	scanf("%c", &ch);

	printf("testing specialBlockBomb()\n");
	/* place a bomb amongst the blocks */
	getFieldPos(field, (TC_FIELD_WIDTH / 2), 
			TC_FIELD_HEIGHT - (TC_FIELD_HEIGHT / 4)) = 14;
	specialBlockBomb(field);
	printField(field);
	scanf("%c", &ch);
	
	printf("testing specialBlockGravity()\n");
	specialBlockGravity(field);
	printField(field);
	scanf("%c", &ch);

	printf("testing specialNuke()\n");
	specialNuke(field);
	printField(field);
	
	free(field);
	return 0;
}
