/*
   Copyright (C) 2003 Christopher Yeoh <cyeoh@samba.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  

   $Id: tcommon.h,v 1.5 2004/01/08 01:51:11 khalek Exp $
*/

#ifndef _TCOMMON_H
#define _TCOMMON_H

#define TCOMMON_PROTOCOL_VERSION 5

#define  _TC_CONNECT 1
#define  _TC_START 2
#define  _TC_COMMAND_MOVE 3
#define  _TC_COMMAND_USE_SPECIAL 4
#define  _TC_COMMAND_GET_FIELD 5
#define  _TC_COMMAND_GET_CURRENT_BLOCK 6
#define  _TC_COMMAND_GET_NEXT_BLOCK 7
#define  _TC_COMMAND_GET_SPECIALS 8
#define  _TC_COMMAND_GET_MESSAGE 9
#define  _TC_COMMAND_SEND_MESSAGE 10
#define  _TC_COMMAND_DISCARD_SPECIAL 11
#define  _TC_COMMAND_GET_SPECIAL_NOTIFICATION 12

struct TC_PlayerData
{
	int PlayerNumber;
	char *PlayerName;
	char *TeamName;
};

struct TC_GameData
{
	int MaxNumSpecials;
	int NumberOfPlayers;
	int PlayerNumber;
	struct TC_PlayerData Players[0];
};

int writeNumBytes(int Socket, const void *Buffer, int NumBytes);
int readNumBytes(int Socket, void *Buffer, int NumBytes);
int writeString(int Socket, const char *String);
char *readString(int Socket);
int writeInt32(int Socket, int Value);
int readInt32(int Socket);

#endif
