/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: speshal.h,v 1.6 2004/01/13 15:07:02 bruce Exp $ 
 */

#ifndef SPESHAL_H
#define SPESHAL_H

#include "tcommon.h"

#define SPECIAL_THRESHHOLD 0
#define TEAM_STR_LENGTH 50
#define SPECIAL_RECURSE_DEPTH 5

typedef struct
{
	int player;
	int rank;
} spTarget;

typedef struct
{
	int *player;
	int rate;
	int depth;
} spPath;

typedef char *fields[6];

spPath getSpPath(fields previousFields, char *specials, int numPlayers, double lastFieldRates[6], int onTeam[6], int ownNumber, spPath previousPath);

void useSpeshals(struct TC_GameData *gData);

spTarget rankSpeshal(struct TC_GameData *gData, char sp);

spTarget bestField(struct TC_GameData *gData);

void copyFields(fields toCopy, fields store);

spPath comparePaths(spPath t1, spPath t2, char *specials);

void freeFields(fields toFree);

void specialAddLine(char *field);
void specialClearSpecials(char *field);
void specialClearLine(char *field);
void specialBlockGravity(char *field);
void specialNuke(char *field);
void specialBlockBomb(char *field);
void specialBlockQuake(char *field);
void specialClearRandom(char *field);
void specialSwitchFields(char *field, char *field2);

#endif
