/*
 * block, a tetribot AI
 * Copyright (C) 2004 Sean Burford <sean.burford@adelaide.edu.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include "block.h"
#include "ai-support.h"

int DropStrategy(unsigned int *field, struct block *curr, struct block *pending, struct block *best, unsigned int alreadyclear, int mode)
{
	int x, y, rot;
	struct block working;
	int bestscore = -20000;
	int bestx = curr->x;
	int besty = curr->y;
	int bestrot = 0;

	if(curr->type == TC_BLOCK_NONE)
		return(bestscore);

	for(rot=0;rot<4;rot++)
	{
		if(UpdateBlock(&working, curr->type, -3, y, rot))
		{
			for(x=-3;x<TC_FIELD_WIDTH+3;x++)
			{
				y=curr->y;
				working.y = y;
				if(!Collision(field, &working))
				{
					int score;

					while(!Collision(field, &working))
					{
						y++;
						working.y = y;
					}
					working.y = y-1;

					if(pending)
					{
						struct block bestpending;
						unsigned int newfield[TC_FIELD_HEIGHT+1], i, prescore;

						prescore = DrawBlockOnField(newfield, field, &working);

						for(i=0;i<TC_FIELD_HEIGHT+1;i++)
							newfield[i]=field[i];
						newfield[working.y] |= working.mask[0];
						newfield[working.y+1] |= working.mask[1];
						newfield[working.y+2] |= working.mask[2];
						newfield[working.y+3] |= working.mask[3];

						score = DropStrategy(newfield, pending, NULL, &bestpending, prescore, mode);
					}
					else
						score = FieldScore2(field, &working, alreadyclear);

					if(bestscore == -20000 ||
					  ((mode == MODE_CLEAR) && (score > bestscore)) ||
					  ((mode == MODE_FILL) && (score < bestscore)))
					{
						bestscore = score;
						bestx = x;
						besty = working.y;
						bestrot = rot;
					}
				}
				// Move 1 unit to the right
				working.x++;
				working.mask[0] >>= 1;
				working.mask[1] >>= 1;
				working.mask[2] >>= 1;
				working.mask[3] >>= 1;
			}
		}
	}
	UpdateBlock(best, curr->type, bestx, besty, bestrot);

	return(bestscore);
}

void DropStrategyMove(struct block *curr, struct block *desired)
{
	int tx = desired->x;
	int x = curr->x;
	int rot = desired->init_rot;

	if(rot == 3)
	{
		MoveBlock(TC_ROTATE_ANTICLOCKWISE);
		rot=0;
	}
	while(rot)
	{
		MoveBlock(TC_ROTATE_CLOCKWISE);
		rot--;
	}
	if(tx != x)
	{
		while(tx < x)
		{
			MoveBlock(TC_MOVE_LEFT);
			x--;
		}
		while(tx > x)
		{
			MoveBlock(TC_MOVE_RIGHT);
			x++;
		}
	}
	else if (desired->init_rot == 0)
		MoveBlock(TC_MOVE_DROP);
}

