/*
 * block, a tetribot AI
 * Copyright (C) 2004 Sean Burford <sean.burford@adelaide.edu.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdio.h>
#include <string.h>
#include "block.h"
#include "ai-support.h"

// 4 rows of block bitmap, right aligned
// 1 next block number
unsigned int blockmap[29][5] = {
	{ 0x00, 0x00, 0x00, 0x00, TC_BLOCK_NONE }, // No Block 0
	{ 0x06, 0x06, 0x00, 0x00, TC_BLOCK_O }, // O 1
	{ 0x0F, 0x00, 0x00, 0x00, TC_BLOCK_I_2 }, // I 2
	{ 0x02, 0x02, 0x02, 0x02, TC_BLOCK_I_1 }, // I 3
	{ 0x03, 0x06, 0x00, 0x00, TC_BLOCK_S_2 }, // S 4
	{ 0x04, 0x06, 0x02, 0x00, TC_BLOCK_S_1 }, // S 5
	{ 0x06, 0x03, 0x00, 0x00, TC_BLOCK_Z_2 }, // Z 6
	{ 0x02, 0x06, 0x04, 0x00, TC_BLOCK_Z_1 }, // Z 7
	{ 0x07, 0x04, 0x00, 0x00, TC_BLOCK_L_2  }, // L 8
	{ 0x04, 0x04, 0x06, 0x00, TC_BLOCK_L_3 }, // L 9
	{ 0x01, 0x07, 0x00, 0x00, TC_BLOCK_L_4 }, // L 10
	{ 0x06, 0x02, 0x02, 0x00, TC_BLOCK_L_1  }, // L 11
	{ 0x07, 0x01, 0x00, 0x00, TC_BLOCK_J_2 }, // J 12
	{ 0x06, 0x04, 0x04, 0x00, TC_BLOCK_J_3 }, // J 13
	{ 0x04, 0x07, 0x00, 0x00, TC_BLOCK_J_4 }, // J 14
	{ 0x02, 0x02, 0x06, 0x00, TC_BLOCK_J_1 }, // J 15
	{ 0x07, 0x02, 0x00, 0x00, TC_BLOCK_T_2 }, // T 16
	{ 0x04, 0x06, 0x04, 0x00, TC_BLOCK_T_3 }, // T 17
	{ 0x02, 0x07, 0x00, 0x00, TC_BLOCK_T_4 }, // T 18
	{ 0x02, 0x06, 0x02, 0x00, TC_BLOCK_T_1 }  // T 19
};

void DrawFieldLine(unsigned int *field, unsigned int y, struct block *bl)
{
	unsigned int bit=0x80000000;

	printf("%02d ", y);

	while(bit)
	{
		char c;

		c = (bit & field[y])?'X':' ';

		if(bl &&
		   (bl->type != 0) && 
		   (y >= bl->y) &&
		   (y <= bl->y + 3))
		{
			int py = y - bl->y;

			if(bit & bl->mask[py])
			c = (c == ' ')?'O':'%';
		}
		printf("%c", c);

		bit >>= 1;
	}

	if(bl && (y == bl->y) && (bl->type != 0))
		printf("\tCurr: %d (%d,%d)", bl->type, bl->x, bl->y);
	printf("\n");
}

unsigned int UpdateBlock(struct block *bl, int type, int x, int y, int rot)
{
	unsigned int shift, z, retval, currtype;

	retval=-1;

	bl->x = x;
	bl->y = y;
	bl->init_rot = rot;

	currtype=type;
	z=rot;
	while(z)
	{
		currtype = blockmap[currtype][4];
		if(currtype == type)
			retval=0;
		z--;
	}

	bl->type = currtype;

	// field is 32 bits wide, - 4 for left border, -4 for block
	shift = 24 - x;

	for(z=0;z<5;z++)
		bl->mask[z] = blockmap[currtype][z] << shift;

	return(retval);
}

unsigned int Collision(unsigned int *field, struct block *bl)
{
	return((field[bl->y] & bl->mask[0]) ||
	       (field[bl->y+1] & bl->mask[1]) ||
	       (field[bl->y+2] & bl->mask[2]) ||
	       (field[bl->y+3] & bl->mask[3]));
}

unsigned int DrawBlockOnField(unsigned int *newf, unsigned int *f, struct block *bl)
{
	unsigned int complete=0, y;

	memcpy(newf, f, sizeof(unsigned int)*(TC_FIELD_HEIGHT+1));

	// Add current piece to field
	if(bl && (bl->type != TC_BLOCK_NONE))
	{
		for(y=bl->y;y<bl->y+4;y++)
		{
			newf[y] |= bl->mask[y - bl->y];
			// Count complete lines
			if((newf[y] == 0xFFFFFFFF) && (bl->mask[y - bl->y]))
				complete++;
		}
	}

	return(complete);
}

int FieldScore2(unsigned int *field, struct block *curr, unsigned int alreadyclear)
{
	unsigned int f[TC_FIELD_HEIGHT+1];
	int score=0, clears=0, blocks=0, x, y;
	unsigned int bit, lastblocked;

	score += 1000*(DrawBlockOnField(f, field, curr));

	bit=0x0C000000;
	for(x=0;x<TC_FIELD_WIDTH-1;x++)
	{
		lastblocked=0;
		for(y=0;y<TC_FIELD_HEIGHT;y++)
		{
			unsigned int blocked = f[y] & bit;

			if(!(blocked | lastblocked))
				clears += TC_FIELD_HEIGHT-y;
			else if ((blocked^bit)&lastblocked)
				blocks -= 10*(y+6);

			lastblocked = blocked;
		}
		bit >>= 1;
	}
	return(score + (alreadyclear * 1500) + clears + blocks);
}


