#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tclient.h"
#include "tetris.h"
#include "specials.h"
#include "field.h"

static signed char field1[TC_FIELD_SIZE], field2[TC_FIELD_SIZE];
static signed char *fields[6] = {field1, field2, NULL, NULL, NULL, NULL};
static int fof[6] = {-1, 1, 0, 0, 0, 0};
static signed char sb[19];

void test_block_bomb(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 3),
         1, TC_FIELD_WIDTH * 3);

  memset(field2, 0, TC_FIELD_SIZE);

  fblock(field1, 5, 20) = TC_SPECIAL_BLOCK_BOMB;

  sb[0] = TC_SPECIAL_BLOCK_BOMB;
  sb[1] = 0;

  eval_specials(fields, fof, sb, 1);
}

void test_block_quake(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 1), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 2), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 3), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 4), 1,
         TC_FIELD_WIDTH - 1);

  memset(field2, 0, TC_FIELD_SIZE);

  sb[0] = TC_SPECIAL_BLOCK_QUAKE;
  sb[1] = 0;

  eval_specials(fields, fof, sb, 1);
}

void test_add(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 1), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 2), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 3), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 4), 1,
         TC_FIELD_WIDTH - 1);

  memset(field2, 0, TC_FIELD_SIZE);

  sb[0] = TC_SPECIAL_ADD_LINE;
  sb[1] = 0;

  eval_specials(fields, fof, sb, 1);
}

void test_clear(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 1), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 2), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 3), 1,
         TC_FIELD_WIDTH - 1);
  memset(field1 + TC_FIELD_WIDTH * (TC_FIELD_HEIGHT - 4), 1,
         TC_FIELD_WIDTH - 1);

  memset(field2, 0, TC_FIELD_SIZE);

  sb[0] = TC_SPECIAL_CLEAR_LINE;
  sb[1] = 0;

  eval_specials(fields, fof, sb, 1);
}

void test_clear_specials(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field2, 0, TC_FIELD_SIZE);
  fblock(field1, 0, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_CLEAR_SPECIALS;
  fblock(field1, 1, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_ADD_LINE;

  sb[0] = TC_SPECIAL_CLEAR_SPECIALS;
  sb[1] = 0;

  eval_specials(fields, fof, sb, 1);
}

void test_switch(void) {
  memset(field1, 0, TC_FIELD_SIZE);
  memset(field2, 0, TC_FIELD_SIZE);
  fblock(field1, 0, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_CLEAR_SPECIALS;
  fblock(field1, 1, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_ADD_LINE;
  fblock(field1, 2, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_SWITCH_FIELDS;
  fblock(field1, 3, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_SWITCH_FIELDS;
  fblock(field1, 4, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_SWITCH_FIELDS;
  fblock(field1, 5, TC_FIELD_HEIGHT - 1) = TC_SPECIAL_SWITCH_FIELDS;

  sb[0] = TC_SPECIAL_SWITCH_FIELDS;
  sb[1] = TC_SPECIAL_SWITCH_FIELDS;
  sb[2] = 0;

  eval_specials(fields, fof, sb, 1);
}

int main(int argc, char *argv[]) {
/*
  test_block_bomb();
  test_block_quake();
  test_add();
  test_clear();
  test_clear_specials();
*/
  test_switch();
  return 0;
}
