#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tclient.h"
#include "tetris.h"
#include "specials.h"
#include "move.h"
#include "field.h"

static int iter = 1;

static signed char *field;

static void free_move_results(MOVE_RESULT **move_results) {
  MOVE_RESULT **search_move_results = move_results;

  if (!move_results) {
    return;
  }

  while (*search_move_results) {
    free(*search_move_results);
    search_move_results++;
  }

  free(move_results);
}

static void show_move_results(MOVE_RESULT **move_results) {
  MOVE_RESULT **search_move_results;
  MOVE_RESULT *move_result;
  int i, j = 0;

  if (!move_results) {
    printf("no moves possible\n");
    return;
  }

  search_move_results = move_results;
  while ((move_result = *search_move_results++)) {
    j++;
    printf("score %d move_count %d moves ",
           move_result->score,
           move_result->move_count);
    for (i = 0; i < move_result->move_count; i++) {
      switch (move_result->moves[i]) {
        case 1:
          printf("ML ");
          break;
        case 2:
          printf("MR ");
          break;
        case 3:
          printf("RL ");
          break;
        case 4:
          printf("RR ");
          break;
        case 5:
          printf("MD ");
          break;
      }
    }
    printf("\n");
    show_field(move_result->field, -1, 0, 0, 0);
    printf("------------------------------\n");
  }
  printf("%d move results\n", j);
}

/* check that pieces rotated when next to the wall get moved in */
void test_move_in(void) {
  MOVE_RESULT **move_results;
  int i;

  memset(field, 0, TC_FIELD_SIZE);
  for (i = 8; i <= 16; i++) {
    fblock(field, 1, i) = 1;
    fblock(field, 2, i) = 1;
  }
  fblock(field, 1, 12) = 0;
  fblock(field, 2, 12) = 0;
  fblock(field, 4, 12) = 1;

  move_results = find_moves(field, "", 0, 0, 4, 0);
  show_move_results(move_results);
  free_move_results(move_results);

  memset(field, 0, TC_FIELD_SIZE);
  for (i = 8; i <= 16; i++) {
    fblock(field,  9, i) = 1;
    fblock(field, 10, i) = 1;
  }
  fblock(field,  9, 12) = 0;
  fblock(field, 10, 12) = 0;
  fblock(field,  7, 12) = 1;

  move_results = find_moves(field, "", 0, 0, 4, 0);
  show_move_results(move_results);
  free_move_results(move_results);
}

void test_find_moves(int block, int scattered_blocks) {
  MOVE_RESULT **move_results;
  int i;

  memset(field, 0, TC_FIELD_SIZE);

  for (i = 0; i < scattered_blocks; i++) {
    field[((i + 1) * 101) % TC_FIELD_SIZE] = 1;
  }

  move_results = find_moves(field, "", block, 0, 4, 0);
  if (iter == 1) {
    show_move_results(move_results);
  }
  free_move_results(move_results);
}

int main(int argc, char *argv[]) {
  struct timeval tv1, tv2;
  int i, block;

  init_beth_move(18);

  field = malloc(TC_FIELD_SIZE);

/*
  test_move_in();
*/

  if (argc == 2) {
    iter = atoi(argv[1]);
  }

  gettimeofday(&tv1, NULL);
  for (i = 0; i < iter; i++) {
    for (block = 0; block < 7; block++) {
      if (iter == 1) {
        printf("block %d\n", block);
      }
      test_find_moves(block, 20);
    }
  }
  gettimeofday(&tv2, NULL);
  if (iter > 1) {
    printf("moves took %.3fs\n", ((tv2.tv_sec + tv2.tv_usec / 1000000.0) -
                                  (tv1.tv_sec + tv1.tv_usec / 1000000.0)));
  }

  free(field);

  return 0;
}
