/*  Copyright (C) 2011 Christopher Yeoh <cyeoh@au1.ibm.com>, IBM Corp. */

#define __USE_MISC
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/uio.h>
#include <string.h>

#include "process_vm.h"

int main(int argc, char *argv[])
{
  int val;
  int pid;
  void *addr;
  unsigned long len;
  char buf[1000];
  char *ref_buf = "THIS IS A TEST";
  struct iovec local;
  struct iovec remote;

  if (argc!=4) {
    printf("%s <pid> <address> <length>\n", argv[0]);
    exit(1);
  }

  pid = atoi(argv[1]);
  sscanf(argv[2], "%p", &addr);
  len = atol(argv[3]);

  printf("Requesting: process: %i address %p length %lu\n", pid, (void*)addr, len);

  local.iov_base = buf;
  local.iov_len = len;
  remote.iov_base = addr;
  remote.iov_len = len;

  val = process_vm_readv(pid, &local, 1, &remote, 1, 0);

  if (val!=len) {
    perror("process_vm_readv failed"); 
    printf("error code: %i\n", errno);
    exit(1);
  } else {
    if (strcmp(ref_buf, buf) == 0) {
      printf("Test passed\n");
      exit(0);
    } else {
      printf("Test failed, received (expected \"%s\") %i \n", ref_buf, strlen(ref_buf));
      printf("%i\n", strlen(buf));
      int i;
      for (i=0; i<len; i++) {
	printf("%x %c ", buf[i], buf[i]);
      }
      printf("\n");
      exit(1);
    }
  }

  return 0;

}
