#include <sys/syscall.h>
#include <sys/unistd.h>
#include <sys/uio.h>

#ifndef SYS_readahead
#define SYS_readahead 187
#endif

static inline ssize_t __readahead(int fd, loff_t offset, size_t count)
{
	return syscall(SYS_readahead, fd, offset, count);
}

#ifndef SYS_fincore
#define SYS_fincore 325
#endif

static inline ssize_t
__fincore(int fd, char *page_vec, loff_t offset, size_t size)
{
	return syscall(SYS_fincore, fd, page_vec, offset, size);
}

#ifndef SYS_preadv
#define SYS_preadv 295
#endif

static inline ssize_t
__preadv(int fd, const struct iovec *iov, int iovcnt, loff_t offset)
{
	return syscall(SYS_preadv, fd, iov, iovcnt, offset);
}

#ifndef SYS_pread
#define SYS_pread 17
#endif

static inline ssize_t
__pread(int fd, void *buf, size_t count, loff_t offset)
{
	return syscall(SYS_pread, fd, buf, count, offset);
}
