#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/syscall.h>
#include <sys/mman.h>

#include <asm/unistd.h>

char *progname;

static void usage(void)
{
	fprintf(stderr, "Usage: %s filename offset length\n", progname);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int c;
	int fd;
	char *filename;
	loff_t offset;
	unsigned long length;
	int ret;
	char *map;

	progname = argv[0];

	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];

	if (optind == argc)
		usage();
	offset = strtoull(argv[optind++], NULL, 0);

	if (optind == argc)
		usage();
	length = strtol(argv[optind++], NULL, 0);

	if (optind != argc)
		usage();

	fd = open(filename, O_RDONLY|O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open `%s': %s\n",
			progname, filename, strerror(errno));
		exit(1);
	}

	map = mmap(NULL, length + getpagesize(),
			PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (map == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}

	ret = remap_file_pages(map, length, PROT_NONE,
				offset / getpagesize(), 0);
	if (ret) {
		fprintf(stderr, "%s: remap_file_pages() failed: %s\n",
			progname, strerror(errno));
		exit(1);
	}
	close(fd);
	exit(0);
}

