/*
 * ftruncate a file
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

int main(int argc, char *argv[])
{
	int fd;
	loff_t size;
	char *filename;
	char *psize;

	if (argc != 3) {
		fprintf(stderr, "Usage; %s filename size\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	psize = argv[2];
	if (!strncmp(psize, "0x", 2))
		size = strtoll(psize + 2, NULL, 16);
	else
		size = strtoll(psize, NULL, 10);
	fd = open(filename, O_RDWR|O_CREAT, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	printf("%s: truncating `%s' to size %Ld\n", argv[0], filename, size);
	if (ftruncate(fd, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	exit(0);
}
